(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11436,        397]
NotebookOptionsPosition[      7975,        299]
NotebookOutlinePosition[      9483,        334]
CellTagsIndexPosition[      9440,        331]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Cycles and Connectivity", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Graph Cycles", "GuideFunctionsSubsection",
 CellID->74708734],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FindCycle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find cycle in a graph"
}], "GuideText",
 CellID->247808495],

Cell[TextData[{
 Cell[TextData[ButtonBox["Girth",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Girth"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "length of the shortest cycle"
}], "GuideText",
 CellID->188103924],

Cell[TextData[{
 Cell[TextData[ButtonBox["EulerianCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EulerianCycle"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find an Eulerian tour on a graph"
}], "GuideText",
 CellID->562688009],

Cell[TextData[{
 Cell[TextData[ButtonBox["HamiltonianCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HamiltonianCycle"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a Hamiltonian cycle"
}], "GuideText",
 CellID->371159217],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExtractCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ExtractCycles"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EulerianQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EulerianQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HamiltonianQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HamiltonianQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AcyclicQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AcyclicQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->295482966],

Cell[TextData[{
 Cell[TextData[ButtonBox["TravelingSalesman",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TravelingSalesman"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TravelingSalesmanBounds",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TravelingSalesmanBounds"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeBruijnSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeBruijnSequence"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->10344822]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Connectivity", "GuideFunctionsSubsection",
 CellID->718426161],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConnectedQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ConnectedQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a graph has only one component"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConnectedComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ConnectedComponents"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get lists of connected vertices"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["StronglyConnectedComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/StronglyConnectedComponents"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeaklyConnectedComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/WeaklyConnectedComponents"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->682356941],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["OrientGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OrientGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find strongly connected orientation of a graph"
}], "GuideText",
 CellID->136721266],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArticulationVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ArticulationVertices"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find cut points of a graph"
}], "GuideText",
 CellID->133242933],

Cell[TextData[{
 Cell[TextData[ButtonBox["Bridges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Bridges"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find bridges of a graph"
}], "GuideText",
 CellID->419980550],

Cell[TextData[{
 Cell[TextData[ButtonBox["BiconnectedComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BiconnectedComponents"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BiconnectedQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BiconnectedQ"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->377264968],

Cell["\t", "GuideDelimiter",
 CellID->134348903],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeConnectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeConnectivity"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "minimal number of edges that disconnect the graph"
}], "GuideText",
 CellID->292795554],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexConnectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexConnectivity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexConnectivityGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexConnectivityGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->247796239]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "GuideMoreAbout",\

 CellID->1567025153],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "GuideMoreAbout",\

 CellID->252299663],

Cell[TextData[ButtonBox["Graph Construction and Representation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cycles and Connectivity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 48.0836006}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "FindCycle -- find cycle in a graph, Girth -- length of the shortest \
cycle, EulerianCycle -- find an Eulerian tour on a graph, HamiltonianCycle -- \
find a Hamiltonian cycle, ConnectedQ -- test if a graph has only one \
component, ConnectedComponents -- get lists of connected vertices, \
OrientGraph -- find strongly connected orientation of a graph, \
ArticulationVertices -- find cut points of a graph, Bridges -- find bridges \
of a graph, EdgeConnectivity -- minimal number of edges that disconnect the \
graph", "synonyms" -> {}, "title" -> "Cycles and Connectivity", "type" -> 
    "Guide", "uri" -> "Combinatorica/guide/CyclesAndConnectivity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[768, 33, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->74708734],
Cell[838, 36, 266, 9, 70, "GuideText",
 CellID->247808495],
Cell[1107, 47, 265, 9, 70, "GuideText",
 CellID->188103924],
Cell[1375, 58, 288, 10, 70, "GuideText",
 CellID->562688009],
Cell[1666, 70, 286, 10, 70, "GuideText",
 CellID->371159217],
Cell[1955, 82, 894, 25, 70, "InlineGuideFunctionListing",
 CellID->295482966],
Cell[2852, 109, 718, 20, 70, "InlineGuideFunctionListing",
 CellID->10344822]
}, Open  ]],
Cell[CellGroupData[{
Cell[3607, 134, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->718426161],
Cell[3684, 137, 285, 9, 70, "GuideText",
 CellID->203374175],
Cell[3972, 148, 300, 10, 70, "GuideText",
 CellID->1463276848],
Cell[4275, 160, 502, 13, 70, "InlineGuideFunctionListing",
 CellID->682356941],
Cell[4780, 175, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[4831, 178, 298, 10, 70, "GuideText",
 CellID->136721266],
Cell[5132, 190, 296, 10, 70, "GuideText",
 CellID->133242933],
Cell[5431, 202, 264, 9, 70, "GuideText",
 CellID->419980550],
Cell[5698, 213, 464, 13, 70, "InlineGuideFunctionListing",
 CellID->377264968],
Cell[6165, 228, 48, 1, 70, "GuideDelimiter",
 CellID->134348903],
Cell[6216, 231, 311, 10, 70, "GuideText",
 CellID->292795554],
Cell[6530, 243, 480, 13, 70, "InlineGuideFunctionListing",
 CellID->247796239]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7059, 262, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7124, 265, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[7321, 274, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7386, 277, 165, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[7554, 283, 164, 4, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[7721, 289, 212, 5, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[7948, 297, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

