(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17723,        604]
NotebookOptionsPosition[     13322,        482]
NotebookOutlinePosition[     14970,        519]
CellTagsIndexPosition[     14927,        516]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Displaying Graphs", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShowGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display a graph"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowGraphArray",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShowGraphArray"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display several graphs"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowLabeledGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShowLabeledGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AnimateGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AnimateGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->61500378],

Cell["\t", "GuideDelimiter",
 CellID->126415646],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetGraphOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetGraphOptions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "set graph display options"
}], "GuideText",
 CellID->114949612],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphOptions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "retrieve graph display options"
}], "GuideText",
 CellID->160231805],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetEdgeLabels",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetEdgeLabels"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetEdgeWeights",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetEdgeWeights"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetVertexLabels",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetVertexLabels"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetVertexWeights",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetVertexWeights"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Zoom",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Zoom"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->487624733],

Cell[CellGroupData[{

Cell["Graph Embedding", "GuideFunctionsSubsection",
 CellID->142925784],

Cell[TextData[{
 Cell[TextData[ButtonBox["CircularEmbedding",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CircularEmbedding"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "place all vertices on a circle"
}], "GuideText",
 CellID->758819512],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChangeVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ChangeVertices"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify coordinates of vertices"
}], "GuideText",
 CellID->51194185],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChangeEdges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ChangeEdges"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "replace edges of a graph"
}], "GuideText",
 CellID->214549081],

Cell["\t", "GuideDelimiter",
 CellID->176319081],

Cell[TextData[{
 Cell[TextData[ButtonBox["RankGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "assign ranks to vertices"
}], "GuideText",
 CellID->144702313],

Cell[TextData[{
 Cell[TextData[ButtonBox["RankedEmbedding",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankedEmbedding"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "place vertices based on their rank"
}], "GuideText",
 CellID->630300097],

Cell[TextData[{
 Cell[TextData[ButtonBox["RadialEmbedding",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RadialEmbedding"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RootedEmbedding",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RootedEmbedding"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpringEmbedding",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SpringEmbedding"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphCenter",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphCenter"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->152880914],

Cell["\t", "GuideDelimiter",
 CellID->577117060],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotateVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RotateVertices"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "rotate vertex positions about the origin"
}], "GuideText",
 CellID->250744871],

Cell[TextData[{
 Cell[TextData[ButtonBox["TranslateVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TranslateVertices"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "shift vertex position by a given vector"
}], "GuideText",
 CellID->125107035],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShakeGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShakeGraph"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HasseDiagram",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HasseDiagram"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->458962239]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Options", "GuideFunctionsSubsection",
 CellID->57889294],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeStyle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "style of displayed edges"
}], "GuideText",
 CellID->5581691],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexStyle"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "style of displayed vertices"
}], "GuideText",
 CellID->330735245],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeColor",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeColor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeLabel",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeLabel"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeWeight",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeWeight"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->391231417],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeDirection",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeDirection"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeLabelColor",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeLabelColor"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeLabelPosition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeLabelPosition"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->59996725],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexColor",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexColor"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexLabel",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexWeight",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexWeight"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->156988796],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexNumber"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexNumberColor",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexNumberColor"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexNumberPosition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexNumberPosition"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->382149858],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexLabelColor",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexLabelColor"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexLabelPosition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexLabelPosition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LoopPosition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LoopPosition"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->229201922],

Cell["\t", "GuideDelimiter",
 CellID->533465848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Highlight",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Highlight"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "highlight elements of a graph"
}], "GuideText",
 CellID->143451078],

Cell[TextData[{
 Cell[TextData[ButtonBox["HighlightedEdgeColors",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HighlightedEdgeColors"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HighlightedVertexColors",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HighlightedVertexColors"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->786711569],

Cell[TextData[{
 Cell[TextData[ButtonBox["HighlightedEdgeStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HighlightedEdgeStyle"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HighlightedVertexStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HighlightedVertexStyle"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->43770727]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Graph Construction and Representation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "GuideMoreAbout",\

 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Displaying Graphs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 48.6929912}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ShowGraph -- display a graph, ShowGraphArray -- display several graphs, \
SetGraphOptions -- set graph display options, GraphOptions -- retrieve graph \
display options, CircularEmbedding -- place all vertices on a circle, \
ChangeVertices -- specify coordinates of vertices, ChangeEdges -- replace \
edges of a graph, RankGraph -- assign ranks to vertices, RankedEmbedding -- \
place vertices based on their rank, RotateVertices -- rotate vertex positions \
about the origin, TranslateVertices -- shift vertex position by a given \
vector, EdgeStyle -- style of displayed edges, VertexStyle -- style of \
displayed vertices, Highlight -- highlight elements of a graph", 
    "synonyms" -> {}, "title" -> "Displaying Graphs", "type" -> "Guide", 
    "uri" -> "Combinatorica/guide/DisplayingGraphs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[681, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[740, 31, 260, 9, 70, "GuideText",
 CellID->203374175],
Cell[1003, 42, 281, 10, 70, "GuideText",
 CellID->1463276848],
Cell[1287, 54, 453, 13, 70, "InlineGuideFunctionListing",
 CellID->61500378],
Cell[1743, 69, 48, 1, 70, "GuideDelimiter",
 CellID->126415646],
Cell[1794, 72, 285, 10, 70, "GuideText",
 CellID->114949612],
Cell[2082, 84, 284, 10, 70, "GuideText",
 CellID->160231805],
Cell[2369, 96, 1146, 33, 70, "InlineGuideFunctionListing",
 CellID->487624733],
Cell[CellGroupData[{
Cell[3540, 133, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->142925784],
Cell[3614, 136, 294, 10, 70, "GuideText",
 CellID->758819512],
Cell[3911, 148, 288, 10, 70, "GuideText",
 CellID->51194185],
Cell[4202, 160, 276, 10, 70, "GuideText",
 CellID->214549081],
Cell[4481, 172, 48, 1, 70, "GuideDelimiter",
 CellID->176319081],
Cell[4532, 175, 269, 9, 70, "GuideText",
 CellID->144702313],
Cell[4804, 186, 294, 10, 70, "GuideText",
 CellID->630300097],
Cell[5101, 198, 925, 26, 70, "InlineGuideFunctionListing",
 CellID->152880914],
Cell[6029, 226, 48, 1, 70, "GuideDelimiter",
 CellID->577117060],
Cell[6080, 229, 298, 10, 70, "GuideText",
 CellID->250744871],
Cell[6381, 241, 303, 10, 70, "GuideText",
 CellID->125107035],
Cell[6687, 253, 439, 12, 70, "InlineGuideFunctionListing",
 CellID->458962239]
}, Open  ]],
Cell[CellGroupData[{
Cell[7163, 270, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->57889294],
Cell[7234, 273, 267, 9, 70, "GuideText",
 CellID->5581691],
Cell[7504, 284, 279, 10, 70, "GuideText",
 CellID->330735245],
Cell[7786, 296, 654, 17, 70, "InlineGuideFunctionListing",
 CellID->391231417],
Cell[8443, 315, 694, 20, 70, "InlineGuideFunctionListing",
 CellID->59996725],
Cell[9140, 337, 675, 20, 70, "InlineGuideFunctionListing",
 CellID->156988796],
Cell[9818, 359, 705, 20, 70, "InlineGuideFunctionListing",
 CellID->382149858],
Cell[10526, 381, 701, 20, 70, "InlineGuideFunctionListing",
 CellID->229201922],
Cell[11230, 403, 48, 1, 70, "GuideDelimiter",
 CellID->533465848],
Cell[11281, 406, 274, 9, 70, "GuideText",
 CellID->143451078],
Cell[11558, 417, 486, 13, 70, "InlineGuideFunctionListing",
 CellID->786711569],
Cell[12047, 432, 481, 13, 70, "InlineGuideFunctionListing",
 CellID->43770727]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12577, 451, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[12642, 454, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[12839, 463, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[12904, 466, 209, 5, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[13116, 473, 164, 4, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[13295, 480, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

