(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20655,        689]
NotebookOptionsPosition[     15652,        551]
NotebookOutlinePosition[     17496,        590]
CellTagsIndexPosition[     17453,        587]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Graph Algorithms", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Shortest Paths", "GuideFunctionsSubsection",
 CellID->60831817],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dijkstra",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Dijkstra"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find single-source shortest paths"
}], "GuideText",
 CellID->61919912],

Cell[TextData[{
 Cell[TextData[ButtonBox["AllPairsShortestPath",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AllPairsShortestPath"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find shortest paths simultaneously for all pairs"
}], "GuideText",
 CellID->646513990],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShortestPath",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShortestPath"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sequence of vertices that define the shortest path"
}], "GuideText",
 CellID->220012178],

Cell[TextData[{
 Cell[TextData[ButtonBox["BellmanFord",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BellmanFord"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Eccentricity",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Eccentricity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Radius",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Radius"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Diameter",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Diameter"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Girth",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Girth"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->42836375],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParentsToPaths",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ParentsToPaths"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphCenter",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphCenter"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphPower",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphPower"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->134211873]
}, Open  ]],

Cell[CellGroupData[{

Cell["Minimum Spanning Trees", "GuideFunctionsSubsection",
 CellID->12351864],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimumSpanningTree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MinimumSpanningTree"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a minimum spanning tree of a graph"
}], "GuideText",
 CellID->160463812],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberOfSpanningTrees",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfSpanningTrees"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of spanning trees"
}], "GuideText",
 CellID->705071103],

Cell[TextData[{
 Cell[TextData[ButtonBox["InitializeUnionFind",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InitializeUnionFind"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindSet",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FindSet"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnionSet",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnionSet"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->111112038],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cofactor",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Cofactor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShortestPathSpanningTree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShortestPathSpanningTree"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MaximumSpanningTree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MaximumSpanningTree"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->103387427],

Cell["\t", "GuideDelimiter",
 CellID->930271299],

Cell[TextData[{
 Cell[TextData[ButtonBox["NetworkFlow",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NetworkFlow"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "maximum flow through a graph"
}], "GuideText",
 CellID->25171273],

Cell[TextData[{
 Cell[TextData[ButtonBox["ResidualFlowGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ResidualFlowGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a directed graph for a graph with respect to flow"
}], "GuideText",
 CellID->281734377],

Cell[TextData[{
 Cell[TextData[ButtonBox["StableMarriage",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/StableMarriage"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "optimal stable marriage defined by lists of permutations"
}], "GuideText",
 CellID->683475451],

Cell["\t", "GuideDelimiter",
 CellID->21869908],

Cell[TextData[{
 Cell[TextData[ButtonBox["MaximalMatching",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MaximalMatching"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute maximal matching of a graph"
}], "GuideText",
 CellID->561216479],

Cell[TextData[{
 Cell[TextData[ButtonBox["BipartiteMatching",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BipartiteMatching"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a maximum bipartite matching"
}], "GuideText",
 CellID->383743712],

Cell[TextData[{
 Cell[TextData[ButtonBox["NoPerfectMatchingGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NoPerfectMatchingGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlternatingPaths",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AlternatingPaths"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BipartiteMatchingAndCover",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BipartiteMatchingAndCover"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->187010409],

Cell["\t", "GuideDelimiter",
 CellID->130343537],

Cell[TextData[{
 Cell[TextData[ButtonBox["PartialOrderQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PartialOrderQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TopologicalSort",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TopologicalSort"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TransitiveClosure",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TransitiveClosure"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TransitiveReduction",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TransitiveReduction"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14520389]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Traversals", "GuideFunctionsSubsection",
 CellID->195168482],

Cell[TextData[{
 Cell[TextData[ButtonBox["DepthFirstTraversal",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DepthFirstTraversal"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "depth-first traversal of a graph"
}], "GuideText",
 CellID->84064033],

Cell[TextData[{
 Cell[TextData[ButtonBox["BreadthFirstTraversal",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BreadthFirstTraversal"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "breadth-first traversal of a graph"
}], "GuideText",
 CellID->413566492]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partial Orders", "GuideFunctionsSubsection",
 CellID->369274520],

Cell[TextData[{
 Cell[TextData[ButtonBox["HasseDiagram",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HasseDiagram"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BooleanAlgebra",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BooleanAlgebra"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IsomorphicQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IsomorphicQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InversionPoset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InversionPoset"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->179695263],

Cell[TextData[{
 Cell[TextData[ButtonBox["DominatingIntegerPartitionQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DominatingIntegerPartitionQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DominationLattice",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DominationLattice"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PartitionLattice",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PartitionLattice"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->938026333],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimumChainPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MinimumChainPartition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MaximumAntichain",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MaximumAntichain"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->231939926]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Isomorphism", "GuideFunctionsSubsection",
 CellID->46169311],

Cell[TextData[{
 Cell[TextData[ButtonBox["Isomorphism",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Isomorphism"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find isomorphism between two graphs"
}], "GuideText",
 CellID->412405695],

Cell[TextData[{
 Cell[TextData[ButtonBox["Equivalences",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Equivalences"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "vertex equivalence classes between two graphs"
}], "GuideText",
 CellID->308081699],

Cell[TextData[{
 Cell[TextData[ButtonBox["IdenticalQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IdenticalQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IsomorphismQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IsomorphismQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Neighborhood",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Neighborhood"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Distances",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Distances"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SelfComplementaryQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SelfComplementaryQ"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->59916643],

Cell[TextData[{
 Cell[TextData[ButtonBox["DegreesOf2Neighborhood",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DegreesOf2Neighborhood"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberOf2Paths",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOf2Paths"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberOfKPaths",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfKPaths"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->828773427]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/CyclesAndConnectivity"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Graph Construction and Representation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "GuideMoreAboutSub",
 CellID->369160130],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PermutationGroups"]], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graph Algorithms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 49.0836262}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Dijkstra -- find single-source shortest paths, AllPairsShortestPath -- \
find shortest paths simultaneously for all pairs, ShortestPath -- sequence of \
vertices that define the shortest path, MinimumSpanningTree -- find a minimum \
spanning tree of a graph, NumberOfSpanningTrees -- number of spanning trees, \
NetworkFlow -- maximum flow through a graph, ResidualFlowGraph -- construct a \
directed graph for a graph with respect to flow, StableMarriage -- optimal \
stable marriage defined by lists of permutations, MaximalMatching -- compute \
maximal matching of a graph, BipartiteMatching -- find a maximum bipartite \
matching, DepthFirstTraversal -- depth-first traversal of a graph, \
BreadthFirstTraversal -- breadth-first traversal of a graph, Isomorphism -- \
find isomorphism between two graphs, Equivalences -- vertex equivalence \
classes between two graphs", "synonyms" -> {}, "title" -> "Graph Algorithms", 
    "type" -> "Guide", "uri" -> "Combinatorica/guide/GraphAlgorithms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[680, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[761, 33, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->60831817],
Cell[833, 36, 275, 9, 70, "GuideText",
 CellID->61919912],
Cell[1111, 47, 318, 10, 70, "GuideText",
 CellID->646513990],
Cell[1432, 59, 304, 10, 70, "GuideText",
 CellID->220012178],
Cell[1739, 71, 1099, 31, 70, "InlineGuideFunctionListing",
 CellID->42836375],
Cell[2841, 104, 674, 19, 70, "InlineGuideFunctionListing",
 CellID->134211873]
}, Open  ]],
Cell[CellGroupData[{
Cell[3552, 128, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->12351864],
Cell[3632, 131, 307, 10, 70, "GuideText",
 CellID->160463812],
Cell[3942, 143, 296, 10, 70, "GuideText",
 CellID->705071103],
Cell[4241, 155, 669, 18, 70, "InlineGuideFunctionListing",
 CellID->111112038],
Cell[4913, 175, 706, 19, 70, "InlineGuideFunctionListing",
 CellID->103387427],
Cell[5622, 196, 48, 1, 70, "GuideDelimiter",
 CellID->930271299],
Cell[5673, 199, 279, 10, 70, "GuideText",
 CellID->25171273],
Cell[5955, 211, 323, 10, 70, "GuideText",
 CellID->281734377],
Cell[6281, 223, 314, 10, 70, "GuideText",
 CellID->683475451],
Cell[6598, 235, 47, 1, 70, "GuideDelimiter",
 CellID->21869908],
Cell[6648, 238, 295, 10, 70, "GuideText",
 CellID->561216479],
Cell[6946, 250, 297, 10, 70, "GuideText",
 CellID->383743712],
Cell[7246, 262, 733, 20, 70, "InlineGuideFunctionListing",
 CellID->187010409],
Cell[7982, 284, 48, 1, 70, "GuideDelimiter",
 CellID->130343537],
Cell[8033, 287, 943, 27, 70, "InlineGuideFunctionListing",
 CellID->14520389]
}, Open  ]],
Cell[CellGroupData[{
Cell[9013, 319, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->195168482],
Cell[9088, 322, 299, 10, 70, "GuideText",
 CellID->84064033],
Cell[9390, 334, 306, 10, 70, "GuideText",
 CellID->413566492]
}, Open  ]],
Cell[CellGroupData[{
Cell[9733, 349, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->369274520],
Cell[9806, 352, 918, 27, 70, "InlineGuideFunctionListing",
 CellID->179695263],
Cell[10727, 381, 727, 20, 70, "InlineGuideFunctionListing",
 CellID->938026333],
Cell[11457, 403, 472, 13, 70, "InlineGuideFunctionListing",
 CellID->231939926]
}, Open  ]],
Cell[CellGroupData[{
Cell[11966, 421, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->46169311],
Cell[12041, 424, 287, 10, 70, "GuideText",
 CellID->412405695],
Cell[12331, 436, 299, 10, 70, "GuideText",
 CellID->308081699],
Cell[12633, 448, 1140, 32, 70, "InlineGuideFunctionListing",
 CellID->59916643],
Cell[13776, 482, 707, 20, 70, "InlineGuideFunctionListing",
 CellID->828773427]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14532, 508, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[14597, 511, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[14794, 520, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[14859, 523, 179, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[15041, 529, 208, 5, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[15252, 536, 183, 4, 70, "GuideMoreAboutSub",
 CellID->369160130],
Cell[15438, 542, 172, 4, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[15625, 549, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

