(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7142,        241]
NotebookOptionsPosition[      5436,        186]
NotebookOutlinePosition[      6450,        215]
CellTagsIndexPosition[      6407,        212]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindCycle" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/FindCycle"], 
          "TreeQ" :> Documentation`HelpLookup[
           "paclet:Combinatorica/ref/TreeQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FindCycle\"\>", 
       2->"\<\"TreeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cycles and Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/CyclesAndConnectivity"], 
          "Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cycles and Connectivity\"\>", 
       2->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AcyclicQ", "ObjectName",
 CellID->11521],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AcyclicQ", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " is acyclic."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30098]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26830],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindCycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FindCycle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/TreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->686481209]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->285956143],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->108306607]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/CyclesAndConnectivity"]], "MoreAbout",\

 CellID->54769119],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->41655608]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AcyclicQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 56.0525546}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "AcyclicQ[g] yields True if graph g is acyclic.", "synonyms" -> {}, 
    "title" -> "AcyclicQ", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/AcyclicQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2065, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2688, 80, 46, 1, 70, "ObjectName",
 CellID->11521],
Cell[2737, 83, 593, 20, 70, "Usage",
 CellID->30098]
}, Open  ]],
Cell[CellGroupData[{
Cell[3367, 108, 311, 9, 70, "SeeAlsoSection",
 CellID->26830],
Cell[3681, 119, 479, 17, 70, "SeeAlso",
 CellID->686481209]
}, Open  ]],
Cell[CellGroupData[{
Cell[4197, 141, 318, 9, 70, "TutorialsSection",
 CellID->285956143],
Cell[4518, 152, 187, 4, 70, "Tutorials",
 CellID->108306607]
}, Open  ]],
Cell[CellGroupData[{
Cell[4742, 161, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5064, 172, 171, 4, 70, "MoreAbout",
 CellID->54769119],
Cell[5238, 178, 156, 3, 70, "MoreAbout",
 CellID->41655608]
}, Open  ]],
Cell[5409, 184, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

