(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7472,        241]
NotebookOptionsPosition[      5614,        186]
NotebookOutlinePosition[      6847,        217]
CellTagsIndexPosition[      6804,        214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BipartiteMatching" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/BipartiteMatching"], 
          "BipartiteMatchingAndCover" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/BipartiteMatchingAndCover"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BipartiteMatching\"\>", 
       2->"\<\"BipartiteMatchingAndCover\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AlternatingPaths", "ObjectName",
 CellID->15089],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AlternatingPaths", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["start", "TI"], ",", 
        StyleBox["ME", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the alternating paths in graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with respect to the matching ",
     Cell[BoxData[
      StyleBox["ME", "TI"]], "InlineFormula"],
     ", starting at the vertices in the list ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     ". The paths are returned in the form of a forest containing trees \
rooted at vertices in ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7688]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1737],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BipartiteMatching",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/BipartiteMatching"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BipartiteMatchingAndCover",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/BipartiteMatchingAndCover"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->881835198],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->252873742]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->59033051]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AlternatingPaths - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 4.3183912}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "AlternatingPaths[g, start, ME] returns the alternating paths in graph g \
with respect to the matching ME, starting at the vertices in the list start. \
The paths are returned in the form of a forest containing trees rooted at \
vertices in start.", "synonyms" -> {}, "title" -> "AlternatingPaths", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/AlternatingPaths"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1985, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2608, 78, 54, 1, 70, "ObjectName",
 CellID->15089],
Cell[2665, 81, 966, 28, 70, "Usage",
 CellID->7688]
}, Open  ]],
Cell[CellGroupData[{
Cell[3668, 114, 310, 9, 70, "SeeAlsoSection",
 CellID->1737],
Cell[3981, 125, 531, 17, 70, "SeeAlso",
 CellID->27745]
}, Open  ]],
Cell[CellGroupData[{
Cell[4549, 147, 318, 9, 70, "TutorialsSection",
 CellID->881835198],
Cell[4870, 158, 187, 4, 70, "Tutorials",
 CellID->252873742]
}, Open  ]],
Cell[CellGroupData[{
Cell[5094, 167, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5416, 178, 156, 3, 70, "MoreAbout",
 CellID->59033051]
}, Open  ]],
Cell[5587, 184, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

