(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8243,        264]
NotebookOptionsPosition[      6429,        209]
NotebookOutlinePosition[      7615,        240]
CellTagsIndexPosition[      7572,        237]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DistinctPermutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DistinctPermutations"], "Isomorphism" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Isomorphism"], 
          "MaximumClique" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/MaximumClique"], 
          "MinimumVertexColoring" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/MinimumVertexColoring"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DistinctPermutations\"\>", 
       2->"\<\"Isomorphism\"\>", 3->"\<\"MaximumClique\"\>", 
       4->"\<\"MinimumVertexColoring\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Backtrack", "ObjectName",
 CellID->26905],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Backtrack", "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["partialQ", "TI"], ",", 
        StyleBox["solutionQ", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs a backtrack search of the state space ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     ", expanding a partial solution so long as ",
     Cell[BoxData[
      StyleBox["partialQ", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " and returning the first complete solution, as identified by ",
     Cell[BoxData[
      StyleBox["solutionQ", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22255],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DistinctPermutations",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DistinctPermutations"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Isomorphism",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Isomorphism"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaximumClique",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MaximumClique"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimumVertexColoring",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MinimumVertexColoring"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14684]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->810364708],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->683863945]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->262452672]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Backtrack - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 11.3810720}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Backtrack[s, partialQ, solutionQ] performs a backtrack search of the \
state space s, expanding a partial solution so long as partialQ is True and \
returning the first complete solution, as identified by solutionQ.", 
    "synonyms" -> {}, "title" -> "Backtrack", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Backtrack"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2247, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2870, 82, 47, 1, 70, "ObjectName",
 CellID->26905],
Cell[2920, 85, 992, 29, 70, "Usage",
 CellID->7251]
}, Open  ]],
Cell[CellGroupData[{
Cell[3949, 119, 311, 9, 70, "SeeAlsoSection",
 CellID->22255],
Cell[4263, 130, 1063, 35, 70, "SeeAlso",
 CellID->14684]
}, Open  ]],
Cell[CellGroupData[{
Cell[5363, 170, 318, 9, 70, "TutorialsSection",
 CellID->810364708],
Cell[5684, 181, 187, 4, 70, "Tutorials",
 CellID->683863945]
}, Open  ]],
Cell[CellGroupData[{
Cell[5908, 190, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6230, 201, 157, 3, 70, "MoreAbout",
 CellID->262452672]
}, Open  ]],
Cell[6402, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

