(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8523,        278]
NotebookOptionsPosition[      6557,        221]
NotebookOutlinePosition[      7899,        254]
CellTagsIndexPosition[      7856,        251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelectionSort" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SelectionSort"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SelectionSort\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/Permutations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BinarySearch", "ObjectName",
 CellID->32108],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BinarySearch", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]searches sorted list ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " for key ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " and gives the position of ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " containing ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     ", if ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " is present in ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ". Otherwise, if ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " is absent in ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ", the function returns ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}], TraditionalForm]], "InlineMath"],
     " where ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " falls between the elements of ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " in positions ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "+", "1"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BinarySearch", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["k", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the position of ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " in the list obtained from ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " by applying ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " to each element in ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3320],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SelectionSort",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/SelectionSort"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21414]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->111264082],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->354964526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutations",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/Permutations"]], "MoreAbout",
 CellID->1299590]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BinarySearch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 12.4904754}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "BinarySearch[l, k] searches sorted list l for key k and gives the \
position of l containing k, if k is present in l. Otherwise, if k is absent \
in l, the function returns (p + 1/2) where k falls between the elements of l \
in positions p and p + 1. BinarySearch[l, k, f] gives the position of k in \
the list obtained from l by applying f to each element in l.", 
    "synonyms" -> {}, "title" -> "BinarySearch", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/BinarySearch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1769, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2392, 74, 50, 1, 70, "ObjectName",
 CellID->32108],
Cell[2445, 77, 2448, 78, 70, "Usage",
 CellID->7535]
}, Open  ]],
Cell[CellGroupData[{
Cell[4930, 160, 310, 9, 70, "SeeAlsoSection",
 CellID->3320],
Cell[5243, 171, 220, 6, 70, "SeeAlso",
 CellID->21414]
}, Open  ]],
Cell[CellGroupData[{
Cell[5500, 182, 318, 9, 70, "TutorialsSection",
 CellID->111264082],
Cell[5821, 193, 187, 4, 70, "Tutorials",
 CellID->354964526]
}, Open  ]],
Cell[CellGroupData[{
Cell[6045, 202, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6367, 213, 148, 3, 70, "MoreAbout",
 CellID->1299590]
}, Open  ]],
Cell[6530, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

