(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8879,        300]
NotebookOptionsPosition[      7059,        245]
NotebookOutlinePosition[      8251,        276]
CellTagsIndexPosition[      8208,        273]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Girth" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Girth"], 
          "RegularGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RegularGraph"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Girth\"\>", 
       2->"\<\"RegularGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CageGraph", "ObjectName",
 CellID->31042],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CageGraph", "[", 
       RowBox[{
        StyleBox["k", "TI"], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a smallest ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-regular graph of girth ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " for certain small values of ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CageGraph", "[", 
       StyleBox["r", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"CageGraph", "[", 
        RowBox[{"3", ","}]}], 
       StyleBox["r", "TI"], "]"}]], "InlineFormula"],
     ". For ",
     Cell[BoxData[
      FormBox[
       RowBox[{"k", "=", "3"}], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " can be ",
     Cell[BoxData[
      FormBox["3", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["4", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["5", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["6", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["7", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["8", TraditionalForm]], "InlineMath"],
     ", or ",
     Cell[BoxData[
      FormBox["10", TraditionalForm]], "InlineMath"],
     ". For ",
     Cell[BoxData[
      FormBox[
       RowBox[{"k", "=", "4"}], TraditionalForm]], "InlineMath"],
     " or ",
     Cell[BoxData[
      FormBox["5", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " can be ",
     Cell[BoxData[
      FormBox["3", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["4", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["5", TraditionalForm]], "InlineMath"],
     ", or ",
     Cell[BoxData[
      FormBox["6", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22808]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27290],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Girth",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Girth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RegularGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->46629403],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->463465428]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->455911573]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CageGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 26.5377100}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CageGraph[k, r] gives a smallest k-regular graph of girth r for certain \
small values of k and r. CageGraph[r] gives CageGraph[3, r]. For k = 3, r can \
be 3, 4, 5, 6, 7, 8, or 10. For k = 4 or 5, r can be 3, 4, 5, or 6.", 
    "synonyms" -> {}, "title" -> "CageGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/CageGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1894, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2517, 77, 47, 1, 70, "ObjectName",
 CellID->31042],
Cell[2567, 80, 2561, 88, 70, "Usage",
 CellID->22808]
}, Open  ]],
Cell[CellGroupData[{
Cell[5165, 173, 311, 9, 70, "SeeAlsoSection",
 CellID->27290],
Cell[5479, 184, 481, 17, 70, "SeeAlso",
 CellID->15311]
}, Open  ]],
Cell[CellGroupData[{
Cell[5997, 206, 317, 9, 70, "TutorialsSection",
 CellID->46629403],
Cell[6317, 217, 187, 4, 70, "Tutorials",
 CellID->463465428]
}, Open  ]],
Cell[CellGroupData[{
Cell[6541, 226, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6863, 237, 154, 3, 70, "MoreAbout",
 CellID->455911573]
}, Open  ]],
Cell[7032, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

