(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8866,        287]
NotebookOptionsPosition[      6894,        229]
NotebookOutlinePosition[      8177,        261]
CellTagsIndexPosition[      8134,        258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChangeVertices" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ChangeVertices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ChangeVertices\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"], 
          "Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Graphs\"\>", 
       2->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ChangeEdges", "ObjectName",
 CellID->18771],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ChangeEdges", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["e", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces the edges of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with the edges in ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     ". ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " can have the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["s", "1"], ",", 
           SubscriptBox["t", "1"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["s", "2"], ",", 
           SubscriptBox["t", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " or the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["s", "1"], ",", 
             SubscriptBox["t", "1"]}], "}"}], ",", 
           SubscriptBox["gr", "1"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["s", "2"], ",", 
             SubscriptBox["t", "2"]}], "}"}], ",", 
           SubscriptBox["gr", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["s", "1"], ",", 
          SubscriptBox["t", "1"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["s", "2"], ",", 
          SubscriptBox["t", "2"]}], "}"}], ",", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " are endpoints of edges and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["gr", "1"], ",", 
        SubscriptBox["gr", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     ", are graphics information associated with edges."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17960],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ChangeVertices",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/ChangeVertices"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6968]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->590203082],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->186412999]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->644575989],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->961628881]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChangeEdges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 26.8814688}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ChangeEdges[g, e] replaces the edges of graph g with the edges in e. e \
can have the form {{s_1, t_1}, {s_2, t_2}, ...} or the form {{{s_1, t_1}, \
gr_1}, {{s_2, t_2}, gr_2}, ...}, where {s_1, t_1}, {s_2, t_2}, ... are \
endpoints of edges and gr_1, gr_2, ..., are graphics information associated \
with edges.", "synonyms" -> {}, "title" -> "ChangeEdges", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/ChangeEdges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1962, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2585, 78, 49, 1, 70, "ObjectName",
 CellID->18771],
Cell[2637, 81, 2414, 77, 70, "Usage",
 CellID->13611]
}, Open  ]],
Cell[CellGroupData[{
Cell[5088, 163, 311, 9, 70, "SeeAlsoSection",
 CellID->17960],
Cell[5402, 174, 221, 6, 70, "SeeAlso",
 CellID->6968]
}, Open  ]],
Cell[CellGroupData[{
Cell[5660, 185, 318, 9, 70, "TutorialsSection",
 CellID->590203082],
Cell[5981, 196, 187, 4, 70, "Tutorials",
 CellID->186412999]
}, Open  ]],
Cell[CellGroupData[{
Cell[6205, 205, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6527, 216, 163, 3, 70, "MoreAbout",
 CellID->644575989],
Cell[6693, 221, 159, 3, 70, "MoreAbout",
 CellID->961628881]
}, Open  ]],
Cell[6867, 227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

