(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6740,        222]
NotebookOptionsPosition[      4970,        168]
NotebookOutlinePosition[      6116,        198]
CellTagsIndexPosition[      6073,        195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CircularVertices" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/CircularVertices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CircularVertices\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CircularEmbedding", "ObjectName",
 CellID->28101],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CircularEmbedding", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a list of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " points equally spaced on a circle. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CircularEmbedding", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]embeds the vertices of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " equally spaced on a circle."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18589],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CircularVertices",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/CircularVertices"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->502004543],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->189886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->368287493]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CircularEmbedding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 34.3660354}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CircularEmbedding[n] constructs a list of n points equally spaced on a \
circle. CircularEmbedding[g] embeds the vertices of g equally spaced on a \
circle.", "synonyms" -> {}, "title" -> "CircularEmbedding", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/CircularEmbedding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1800, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2423, 75, 55, 1, 70, "ObjectName",
 CellID->28101],
Cell[2481, 78, 810, 24, 70, "Usage",
 CellID->30031]
}, Open  ]],
Cell[CellGroupData[{
Cell[3328, 107, 311, 9, 70, "SeeAlsoSection",
 CellID->18589],
Cell[3642, 118, 226, 6, 70, "SeeAlso",
 CellID->12270]
}, Open  ]],
Cell[CellGroupData[{
Cell[3905, 129, 318, 9, 70, "TutorialsSection",
 CellID->502004543],
Cell[4226, 140, 184, 4, 70, "Tutorials",
 CellID->189886]
}, Open  ]],
Cell[CellGroupData[{
Cell[4447, 149, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4769, 160, 159, 3, 70, "MoreAbout",
 CellID->368287493]
}, Open  ]],
Cell[4943, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

