(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8598,        272]
NotebookOptionsPosition[      6596,        215]
NotebookOutlinePosition[      7972,        248]
CellTagsIndexPosition[      7929,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CirculantGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/CirculantGraph"],
           "CompleteKPartiteGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/CompleteKPartiteGraph"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CirculantGraph\"\>", 
       2->"\<\"CompleteKPartiteGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CompleteGraph", "ObjectName",
 CellID->24534],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CompleteGraph", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a complete graph on ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices. An option ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that takes on the values ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " is allowed. The default setting for this option is ",
     Cell[BoxData[
      RowBox[{"Type", "->", 
       ButtonBox["Undirected",
        BaseStyle->"Link",
        ButtonData->"paclet:Combinatorica/ref/Undirected"]}]], 
      "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CompleteGraph", "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["c", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a complete ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-partite graph of the prescribed shape. The use of ",
     Cell[BoxData["CompleteGraph"], "InlineFormula"],
     " to create a complete ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-partite graph is obsolete; use ",
     Cell[BoxData[
      ButtonBox["CompleteKPartiteGraph",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/CompleteKPartiteGraph"]], 
      "InlineFormula"],
     " instead."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->6398]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3253],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CirculantGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/CirculantGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompleteKPartiteGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/CompleteKPartiteGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1924]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->147080298],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->408768535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->140930916]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CompleteGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 35.5535658}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CompleteGraph[n] creates a complete graph on n vertices. An option Type \
that takes on the values Directed or Undirected is allowed. The default \
setting for this option is Type -> Undirected. CompleteGraph[a, b, c, ...] \
creates a complete k-partite graph of the prescribed shape. The use of \
CompleteGraph to create a complete k-partite graph is obsolete; use \
CompleteKPartiteGraph instead.", "synonyms" -> {}, "title" -> "CompleteGraph",
     "type" -> "Symbol", "uri" -> "Combinatorica/ref/CompleteGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1948, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2571, 77, 51, 1, 70, "ObjectName",
 CellID->24534],
Cell[2625, 80, 2005, 58, 70, "Usage",
 CellID->6398]
}, Open  ]],
Cell[CellGroupData[{
Cell[4667, 143, 310, 9, 70, "SeeAlsoSection",
 CellID->3253],
Cell[4980, 154, 516, 17, 70, "SeeAlso",
 CellID->1924]
}, Open  ]],
Cell[CellGroupData[{
Cell[5533, 176, 318, 9, 70, "TutorialsSection",
 CellID->147080298],
Cell[5854, 187, 187, 4, 70, "Tutorials",
 CellID->408768535]
}, Open  ]],
Cell[CellGroupData[{
Cell[6078, 196, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6400, 207, 154, 3, 70, "MoreAbout",
 CellID->140930916]
}, Open  ]],
Cell[6569, 213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

