(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8401,        269]
NotebookOptionsPosition[      6473,        213]
NotebookOutlinePosition[      7776,        245]
CellTagsIndexPosition[      7733,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CompleteGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/CompleteGraph"], 
          "GraphJoin" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphJoin"], 
          "Turan" :> Documentation`HelpLookup[
           "paclet:Combinatorica/ref/Turan"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CompleteGraph\"\>", 2->"\<\"GraphJoin\"\>", 
       3->"\<\"Turan\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CompleteKPartiteGraph", "ObjectName",
 CellID->19460],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CompleteKPartiteGraph", "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["c", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a complete ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-partite graph of the prescribed shape, provided the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " arguments ",
     Cell[BoxData[
      FormBox[
       RowBox[{"a", ",", "b", ",", "c", ",", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " are positive integers. An option ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that takes on the values ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " is allowed. The default setting for this option is ",
     Cell[BoxData[
      RowBox[{"Type", "->", 
       ButtonBox["Undirected",
        BaseStyle->"Link",
        ButtonData->"paclet:Combinatorica/ref/Undirected"]}]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28184]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8106],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompleteGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/CompleteGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphJoin",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphJoin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Turan",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Turan"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7413]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->532278460],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->13321373]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->88597463]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CompleteKPartiteGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 42.3818656}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CompleteKPartiteGraph[a, b, c, ...] creates a complete k-partite graph \
of the prescribed shape, provided the k arguments a, b, c, ... are positive \
integers. An option Type that takes on the values Directed or Undirected is \
allowed. The default setting for this option is Type -> Undirected.", 
    "synonyms" -> {}, "title" -> "CompleteKPartiteGraph", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/CompleteKPartiteGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2011, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2634, 78, 59, 1, 70, "ObjectName",
 CellID->19460],
Cell[2696, 81, 1586, 46, 70, "Usage",
 CellID->28184]
}, Open  ]],
Cell[CellGroupData[{
Cell[4319, 132, 310, 9, 70, "SeeAlsoSection",
 CellID->8106],
Cell[4632, 143, 743, 26, 70, "SeeAlso",
 CellID->7413]
}, Open  ]],
Cell[CellGroupData[{
Cell[5412, 174, 318, 9, 70, "TutorialsSection",
 CellID->532278460],
Cell[5733, 185, 186, 4, 70, "Tutorials",
 CellID->13321373]
}, Open  ]],
Cell[CellGroupData[{
Cell[5956, 194, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6278, 205, 153, 3, 70, "MoreAbout",
 CellID->88597463]
}, Open  ]],
Cell[6446, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

