(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7806,        255]
NotebookOptionsPosition[      5973,        199]
NotebookOutlinePosition[      7120,        229]
CellTagsIndexPosition[      7077,        226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AcyclicQ" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AcyclicQ"], 
          "RegularGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RegularGraph"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AcyclicQ\"\>", 
       2->"\<\"RegularGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Built-in Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cycle", "ObjectName",
 CellID->27544],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Cycle", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs the cycle on ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices, the 2-regular connected graph. An option ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that takes on values ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " is allowed. The default setting is ",
     Cell[BoxData[
      RowBox[{"Type", "->", "Undirected"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2420],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AcyclicQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AcyclicQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RegularGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9431]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->85692181],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->29830090]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->114574696],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->504915959]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cycle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 51.0852134}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Cycle[n] constructs the cycle on n vertices, the 2-regular connected \
graph. An option Type that takes on values Directed or Undirected is allowed. \
The default setting is Type -> Undirected.", "synonyms" -> {}, "title" -> 
    "Cycle", "type" -> "Symbol", "uri" -> "Combinatorica/ref/Cycle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2129, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2752, 82, 43, 1, 70, "ObjectName",
 CellID->27544],
Cell[2798, 85, 1034, 30, 70, "Usage",
 CellID->4605]
}, Open  ]],
Cell[CellGroupData[{
Cell[3869, 120, 310, 9, 70, "SeeAlsoSection",
 CellID->2420],
Cell[4182, 131, 486, 17, 70, "SeeAlso",
 CellID->9431]
}, Open  ]],
Cell[CellGroupData[{
Cell[4705, 153, 317, 9, 70, "TutorialsSection",
 CellID->85692181],
Cell[5025, 164, 186, 4, 70, "Tutorials",
 CellID->29830090]
}, Open  ]],
Cell[CellGroupData[{
Cell[5248, 173, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5570, 184, 154, 3, 70, "MoreAbout",
 CellID->114574696],
Cell[5727, 189, 204, 5, 70, "MoreAbout",
 CellID->504915959]
}, Open  ]],
Cell[5946, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

