(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7992,        260]
NotebookOptionsPosition[      6136,        203]
NotebookOutlinePosition[      7303,        234]
CellTagsIndexPosition[      7260,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DistinctPermutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DistinctPermutations"], "OrbitInventory" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/OrbitInventory"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DistinctPermutations\"\>", 
       2->"\<\"OrbitInventory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"], 
          "Subsets and Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndPermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Permutation Groups\"\>", 
       2->"\<\"Subsets and Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CycleIndex", "ObjectName",
 CellID->20456],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CycleIndex", "[", 
       RowBox[{
        StyleBox["pg", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the polynomial in ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], ",", 
        RowBox[{"x", "[", "2", "]"}], ",", "\[Ellipsis]", ",", 
        RowBox[{"x", "[", 
         RowBox[{
          StyleBox["index", "TI"], "[", 
          StyleBox["pg", "TI"], "]"}], "]"}]}], TraditionalForm]], 
      "InlineMath"],
     " that is the cycle index of the permutation group ",
     Cell[BoxData[
      StyleBox["pg", "TI"]], "InlineFormula"],
     ". Here ",
     Cell[BoxData[
      RowBox[{
       StyleBox["index", "TI"], "[", 
       StyleBox["pg", "TI"], "]"}]], "InlineFormula"],
     " refers to the length of each permutation in ",
     Cell[BoxData[
      StyleBox["pg", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17809],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DistinctPermutations",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DistinctPermutations"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrbitInventory",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrbitInventory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->654281888],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->563991205]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->261258993],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "MoreAbout",
 CellID->95013038]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CycleIndex - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 50.8977086}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CycleIndex[pg, x] returns the polynomial in x[1], x[2], ..., \
x[index[pg]] that is the cycle index of the permutation group pg. Here \
index[pg] refers to the length of each permutation in pg.", "synonyms" -> {}, 
    "title" -> "CycleIndex", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/CycleIndex"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2146, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2769, 81, 48, 1, 70, "ObjectName",
 CellID->20456],
Cell[2820, 84, 1166, 36, 70, "Usage",
 CellID->4198]
}, Open  ]],
Cell[CellGroupData[{
Cell[4023, 125, 311, 9, 70, "SeeAlsoSection",
 CellID->17809],
Cell[4337, 136, 515, 17, 70, "SeeAlso",
 CellID->30125]
}, Open  ]],
Cell[CellGroupData[{
Cell[4889, 158, 318, 9, 70, "TutorialsSection",
 CellID->654281888],
Cell[5210, 169, 187, 4, 70, "Tutorials",
 CellID->563991205]
}, Open  ]],
Cell[CellGroupData[{
Cell[5434, 178, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5756, 189, 161, 3, 70, "MoreAbout",
 CellID->261258993],
Cell[5920, 194, 174, 4, 70, "MoreAbout",
 CellID->95013038]
}, Open  ]],
Cell[6109, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

