(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6761,        217]
NotebookOptionsPosition[      5043,        167]
NotebookOutlinePosition[      6301,        199]
CellTagsIndexPosition[      6258,        196]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListNecklaces" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ListNecklaces"], 
          "NecklacePolynomial" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NecklacePolynomial"], 
          "NumberOfNecklaces" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NumberOfNecklaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListNecklaces\"\>", 
       2->"\<\"NecklacePolynomial\"\>", 
       3->"\<\"NumberOfNecklaces\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cyclic", "ObjectName",
 CellID->797],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Cyclic"], "InlineFormula"],
     "\[LineSeparator]is an argument to the Polya-theoretic functions ",
     Cell[BoxData[
      ButtonBox["ListNecklaces",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/ListNecklaces"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["NumberOfNecklaces",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/NumberOfNecklaces"]], 
      "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["NecklacePolynomial",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/NecklacePolynomial"]], 
      "InlineFormula"],
     ", which count or enumerate distinct necklaces. ",
     Cell[BoxData["Cyclic"], "InlineFormula"],
     " refers to the cyclic group acting on necklaces to make equivalent \
necklaces that can be obtained from each other by rotation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23443],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListNecklaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ListNecklaces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NecklacePolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NecklacePolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfNecklaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NumberOfNecklaces"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30992]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->415136513],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->56710258]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cyclic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 58.3979006}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Cyclic is an argument to the Polya-theoretic functions ListNecklaces, \
NumberOfNecklaces, and NecklacePolynomial, which count or enumerate distinct \
necklaces. Cyclic refers to the cyclic group acting on necklaces to make \
equivalent necklaces that can be obtained from each other by rotation.", 
    "synonyms" -> {}, "title" -> "Cyclic", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Cyclic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1529, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2152, 66, 42, 1, 70, "ObjectName",
 CellID->797],
Cell[2197, 69, 1123, 31, 70, "Usage",
 CellID->141]
}, Open  ]],
Cell[CellGroupData[{
Cell[3357, 105, 311, 9, 70, "SeeAlsoSection",
 CellID->23443],
Cell[3671, 116, 786, 26, 70, "SeeAlso",
 CellID->30992]
}, Open  ]],
Cell[CellGroupData[{
Cell[4494, 147, 318, 9, 70, "TutorialsSection",
 CellID->415136513],
Cell[4815, 158, 186, 4, 70, "Tutorials",
 CellID->56710258]
}, Open  ]],
Cell[5016, 165, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

