(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8810,        282]
NotebookOptionsPosition[      6758,        224]
NotebookOutlinePosition[      8185,        258]
CellTagsIndexPosition[      8142,        255]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeBruijnSequence" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DeBruijnSequence"], "Hypercube" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Hypercube"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DeBruijnSequence\"\>", 
       2->"\<\"Hypercube\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeBruijnGraph", "ObjectName",
 CellID->4987],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeBruijnGraph", "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "-dimensional De Bruijn graph with ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " symbols for integers ",
     Cell[BoxData[
      FormBox[
       RowBox[{"m", ">", "0"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", ">", "1"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeBruijnGraph", "[", 
       RowBox[{
        StyleBox["alph", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "-dimensional De Bruijn graph with symbols from ",
     Cell[BoxData[
      StyleBox["alph", "TI"]], "InlineFormula"],
     ". Here ",
     Cell[BoxData[
      StyleBox["alph", "TI"]], "InlineFormula"],
     " is nonempty and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", ">", "1"}], TraditionalForm]], "InlineMath"],
     " is an integer. In the latter form, the function accepts an option ",
     Cell[BoxData[
      ButtonBox["VertexLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
     
     ", with default value ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ", which can be set to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", if users want to associate strings on ",
     Cell[BoxData[
      StyleBox["alph", "TI"]], "InlineFormula"],
     " to the vertices as labels."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9501]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11694],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeBruijnSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeBruijnSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypercube",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Hypercube"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8130]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->274382091],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->24961133]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->532684903]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeBruijnGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 58.5697800}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DeBruijnGraph[m, n] constructs the n-dimensional De Bruijn graph with m \
symbols for integers m > 0 and n > 1. DeBruijnGraph[alph, n] constructs the \
n-dimensional De Bruijn graph with symbols from alph. Here alph is nonempty \
and n > 1 is an integer. In the latter form, the function accepts an option \
VertexLabel, with default value False, which can be set to True, if users \
want to associate strings on alph to the vertices as labels.", 
    "synonyms" -> {}, "title" -> "DeBruijnGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/DeBruijnGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1908, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2531, 76, 50, 1, 70, "ObjectName",
 CellID->4987],
Cell[2584, 79, 2228, 68, 70, "Usage",
 CellID->9501]
}, Open  ]],
Cell[CellGroupData[{
Cell[4849, 152, 311, 9, 70, "SeeAlsoSection",
 CellID->11694],
Cell[5163, 163, 496, 17, 70, "SeeAlso",
 CellID->8130]
}, Open  ]],
Cell[CellGroupData[{
Cell[5696, 185, 318, 9, 70, "TutorialsSection",
 CellID->274382091],
Cell[6017, 196, 186, 4, 70, "Tutorials",
 CellID->24961133]
}, Open  ]],
Cell[CellGroupData[{
Cell[6240, 205, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6562, 216, 154, 3, 70, "MoreAbout",
 CellID->532684903]
}, Open  ]],
Cell[6731, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

