(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7729,        252]
NotebookOptionsPosition[      5848,        196]
NotebookOutlinePosition[      7104,        228]
CellTagsIndexPosition[      7061,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExtractCycles" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ExtractCycles"], 
          "FindCycle" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/FindCycle"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ExtractCycles\"\>", 
       2->"\<\"FindCycle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeleteCycle", "ObjectName",
 CellID->11754],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeleteCycle", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes a simple cycle ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " from graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " is specified as a sequence of vertices in which the first and last \
vertices are identical. ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " can be directed or undirected. If ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " does not contain ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     ", it is returned unchanged; otherwise ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " is returned with ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " deleted."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17801]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->610],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExtractCycles",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ExtractCycles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindCycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FindCycle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4047]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->576179928],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->17593900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->111765471]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeleteCycle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 59.4135516}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DeleteCycle[g, c] deletes a simple cycle c from graph g. c is specified \
as a sequence of vertices in which the first and last vertices are identical. \
g can be directed or undirected. If g does not contain c, it is returned \
unchanged; otherwise g is returned with c deleted.", "synonyms" -> {}, 
    "title" -> "DeleteCycle", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/DeleteCycle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1919, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2542, 77, 49, 1, 70, "ObjectName",
 CellID->11754],
Cell[2594, 80, 1307, 39, 70, "Usage",
 CellID->17801]
}, Open  ]],
Cell[CellGroupData[{
Cell[3938, 124, 309, 9, 70, "SeeAlsoSection",
 CellID->610],
Cell[4250, 135, 490, 17, 70, "SeeAlso",
 CellID->4047]
}, Open  ]],
Cell[CellGroupData[{
Cell[4777, 157, 318, 9, 70, "TutorialsSection",
 CellID->576179928],
Cell[5098, 168, 186, 4, 70, "Tutorials",
 CellID->17593900]
}, Open  ]],
Cell[CellGroupData[{
Cell[5321, 177, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5643, 188, 163, 3, 70, "MoreAbout",
 CellID->111765471]
}, Open  ]],
Cell[5821, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

