(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8142,        262]
NotebookOptionsPosition[      6147,        205]
NotebookOutlinePosition[      7514,        238]
CellTagsIndexPosition[      7471,        235]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AddEdge" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AddEdge"], 
          "DeleteVertex" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DeleteVertex"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AddEdge\"\>", 
       2->"\<\"DeleteVertex\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeleteEdge", "ObjectName",
 CellID->13645],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeleteEdge", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["e", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " minus ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     ". If ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " is undirected, then ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " is treated as an undirected edge, otherwise it is treated as a \
directed edge. If there are multiple edges between the specified vertices, \
only one edge is deleted. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeleteEdge", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["e", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]will delete all edges between the specified pair of \
vertices. Using the tag ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " as a third argument in ",
     Cell[BoxData["DeleteEdge"], "InlineFormula"],
     " is now obsolete."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22449]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11852],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddEdge",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AddEdge"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteVertex",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeleteVertex"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5386]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->134106441],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->385302948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->714362616]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeleteEdge - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 59.6010564}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DeleteEdge[g, e] gives graph g minus e. If g is undirected, then e is \
treated as an undirected edge, otherwise it is treated as a directed edge. If \
there are multiple edges between the specified vertices, only one edge is \
deleted. DeleteEdge[g, e, All] will delete all edges between the specified \
pair of vertices. Using the tag Directed as a third argument in DeleteEdge is \
now obsolete.", "synonyms" -> {}, "title" -> "DeleteEdge", "type" -> "Symbol",
     "uri" -> "Combinatorica/ref/DeleteEdge"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1921, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2544, 78, 48, 1, 70, "ObjectName",
 CellID->13645],
Cell[2595, 81, 1608, 47, 70, "Usage",
 CellID->22449]
}, Open  ]],
Cell[CellGroupData[{
Cell[4240, 133, 311, 9, 70, "SeeAlsoSection",
 CellID->11852],
Cell[4554, 144, 484, 17, 70, "SeeAlso",
 CellID->5386]
}, Open  ]],
Cell[CellGroupData[{
Cell[5075, 166, 318, 9, 70, "TutorialsSection",
 CellID->134106441],
Cell[5396, 177, 187, 4, 70, "Tutorials",
 CellID->385302948]
}, Open  ]],
Cell[CellGroupData[{
Cell[5620, 186, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5942, 197, 163, 3, 70, "MoreAbout",
 CellID->714362616]
}, Open  ]],
Cell[6120, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

