(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7332,        246]
NotebookOptionsPosition[      5587,        192]
NotebookOutlinePosition[      6706,        222]
CellTagsIndexPosition[      6663,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AddVertices" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AddVertices"], 
          "DeleteEdges" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DeleteEdges"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AddVertices\"\>", 
       2->"\<\"DeleteEdges\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeleteVertices", "ObjectName",
 CellID->31966],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeleteVertices", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["vList", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes vertices in ",
     Cell[BoxData[
      StyleBox["vList", "TI"]], "InlineFormula"],
     " from graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". ",
     Cell[BoxData[
      StyleBox["vList", "TI"]], "InlineFormula"],
     " has the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "\[Ellipsis]"}], "}"}], TraditionalForm]],
       "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox[
       RowBox[{"i", ",", "j", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     " are vertex numbers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7770]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10477],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddVertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AddVertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeleteEdges"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6209]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->90656248],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->254387402]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->159651003]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeleteVertices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 6.7574896}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DeleteVertices[g, vList] deletes vertices in vList from graph g. vList \
has the form {i, j, ...}, where i, j, ... are vertex numbers.", 
    "synonyms" -> {}, "title" -> "DeleteVertices", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/DeleteVertices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1930, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2553, 78, 52, 1, 70, "ObjectName",
 CellID->31966],
Cell[2608, 81, 1030, 34, 70, "Usage",
 CellID->7770]
}, Open  ]],
Cell[CellGroupData[{
Cell[3675, 120, 311, 9, 70, "SeeAlsoSection",
 CellID->10477],
Cell[3989, 131, 490, 17, 70, "SeeAlso",
 CellID->6209]
}, Open  ]],
Cell[CellGroupData[{
Cell[4516, 153, 317, 9, 70, "TutorialsSection",
 CellID->90656248],
Cell[4836, 164, 187, 4, 70, "Tutorials",
 CellID->254387402]
}, Open  ]],
Cell[CellGroupData[{
Cell[5060, 173, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5382, 184, 163, 3, 70, "MoreAbout",
 CellID->159651003]
}, Open  ]],
Cell[5560, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

