(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7829,        250]
NotebookOptionsPosition[      5877,        193]
NotebookOutlinePosition[      7201,        226]
CellTagsIndexPosition[      7158,        223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ShortestPath" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ShortestPath"], 
          "ShortestPathSpanningTree" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShortestPathSpanningTree"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ShortestPath\"\>", 
       2->"\<\"ShortestPathSpanningTree\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dijkstra", "ObjectName",
 CellID->6115],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Dijkstra", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a shortest-path spanning tree and associated \
distances from vertex ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". The shortest-path spanning tree is given by a list in which element ",
     
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " is the predecessor of vertex ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " in the shortest-path spanning tree. ",
     Cell[BoxData["Dijkstra"], "InlineFormula"],
     " does not work correctly when the edge weights are negative; ",
     Cell[BoxData[
      ButtonBox["BellmanFord",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/BellmanFord"]], "InlineFormula"],
     
     " should be used in this case."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25582],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPathSpanningTree",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPathSpanningTree"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20931]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->162557637],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->121206160]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->106202611]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dijkstra - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 14.5858150}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Dijkstra[g, v] gives a shortest-path spanning tree and associated \
distances from vertex v of graph g. The shortest-path spanning tree is given \
by a list in which element i is the predecessor of vertex i in the \
shortest-path spanning tree. Dijkstra does not work correctly when the edge \
weights are negative; BellmanFord should be used in this case.", 
    "synonyms" -> {}, "title" -> "Dijkstra", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Dijkstra"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1955, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2578, 77, 45, 1, 70, "ObjectName",
 CellID->6115],
Cell[2626, 80, 1278, 36, 70, "Usage",
 CellID->28056]
}, Open  ]],
Cell[CellGroupData[{
Cell[3941, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->25582],
Cell[4255, 132, 519, 17, 70, "SeeAlso",
 CellID->20931]
}, Open  ]],
Cell[CellGroupData[{
Cell[4811, 154, 318, 9, 70, "TutorialsSection",
 CellID->162557637],
Cell[5132, 165, 187, 4, 70, "Tutorials",
 CellID->121206160]
}, Open  ]],
Cell[CellGroupData[{
Cell[5356, 174, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5678, 185, 157, 3, 70, "MoreAbout",
 CellID->106202611]
}, Open  ]],
Cell[5850, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

