(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8041,        263]
NotebookOptionsPosition[      6237,        208]
NotebookOutlinePosition[      7414,        239]
CellTagsIndexPosition[      7371,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalizeVertices" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NormalizeVertices"], "RotateVertices" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RotateVertices"],
           "TranslateVertices" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/TranslateVertices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NormalizeVertices\"\>", 
       2->"\<\"RotateVertices\"\>", 
       3->"\<\"TranslateVertices\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DilateVertices", "ObjectName",
 CellID->11842],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DilateVertices", "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]multiplies each coordinate of each vertex position in \
list ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " by ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     ", thus dilating the embedding. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DilateVertices", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]dilates the embedding of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " by the factor ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26671],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalizeVertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NormalizeVertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotateVertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RotateVertices"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TranslateVertices",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/TranslateVertices"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->440224822],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->116935905]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->616116620]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DilateVertices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 14.7733198}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DilateVertices[v, d] multiplies each coordinate of each vertex position \
in list v by d, thus dilating the embedding. DilateVertices[g, d] dilates the \
embedding of graph g by the factor d.", "synonyms" -> {}, "title" -> 
    "DilateVertices", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/DilateVertices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2165, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2788, 82, 52, 1, 70, "ObjectName",
 CellID->11842],
Cell[2843, 85, 1108, 35, 70, "Usage",
 CellID->4703]
}, Open  ]],
Cell[CellGroupData[{
Cell[3988, 125, 311, 9, 70, "SeeAlsoSection",
 CellID->26671],
Cell[4302, 136, 785, 26, 70, "SeeAlso",
 CellID->3729]
}, Open  ]],
Cell[CellGroupData[{
Cell[5124, 167, 318, 9, 70, "TutorialsSection",
 CellID->440224822],
Cell[5445, 178, 187, 4, 70, "Tutorials",
 CellID->116935905]
}, Open  ]],
Cell[CellGroupData[{
Cell[5669, 187, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5991, 198, 204, 5, 70, "MoreAbout",
 CellID->616116620]
}, Open  ]],
Cell[6210, 206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

