(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7673,        251]
NotebookOptionsPosition[      5814,        196]
NotebookOutlinePosition[      7047,        227]
CellTagsIndexPosition[      7004,        224]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PartitionQ" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/PartitionQ"], 
          "Partitions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Partitions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"PartitionQ\"\>", 
       2->"\<\"Partitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DominatingIntegerPartitionQ", "ObjectName",
 CellID->1332],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DominatingIntegerPartitionQ", "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if integer partition ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " dominates integer partition ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     ", that is, the sum of a size-",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " prefix of ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " is no smaller than the sum of a size-",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " prefix of ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     " for every ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2515]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24025],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PartitionQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/PartitionQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partitions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Partitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8667]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->118052789],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->144140697]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->280786456]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DominatingIntegerPartitionQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 16.0233518}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DominatingIntegerPartitionQ[a, b] yields True if integer partition a \
dominates integer partition b, that is, the sum of a size-t prefix of a is no \
smaller than the sum of a size-t prefix of b for every t.", "synonyms" -> {}, 
    "title" -> "DominatingIntegerPartitionQ", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/DominatingIntegerPartitionQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1896, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2519, 76, 64, 1, 70, "ObjectName",
 CellID->1332],
Cell[2586, 79, 1288, 40, 70, "Usage",
 CellID->2515]
}, Open  ]],
Cell[CellGroupData[{
Cell[3911, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->24025],
Cell[4225, 135, 486, 17, 70, "SeeAlso",
 CellID->8667]
}, Open  ]],
Cell[CellGroupData[{
Cell[4748, 157, 318, 9, 70, "TutorialsSection",
 CellID->118052789],
Cell[5069, 168, 187, 4, 70, "Tutorials",
 CellID->144140697]
}, Open  ]],
Cell[CellGroupData[{
Cell[5293, 177, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5615, 188, 157, 3, 70, "MoreAbout",
 CellID->280786456]
}, Open  ]],
Cell[5787, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

