(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8204,        265]
NotebookOptionsPosition[      6272,        209]
NotebookOutlinePosition[      7576,        241]
CellTagsIndexPosition[      7533,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListGraphs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ListGraphs"], 
          "NumberOfGraphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NumberOfGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListGraphs\"\>", 
       2->"\<\"NumberOfGraphs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphPolynomial", "ObjectName",
 CellID->19328],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphPolynomial", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a polynomial in ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in which the coefficient of ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["x", "m"], TraditionalForm]], "InlineMath"],
     " is the number of nonisomorphic graphs with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices and ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " edges. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphPolynomial", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        ButtonBox["Directed",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Directed"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns a polynomial in ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in which the coefficient of ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["x", "m"], TraditionalForm]], "InlineMath"],
     " is the number of nonisomorphic directed graphs with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices and ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " edges."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10193]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31773],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListGraphs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ListGraphs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfGraphs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NumberOfGraphs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24623]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->333162408],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->94391750]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->442821177]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphPolynomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 11.1653884}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "GraphPolynomial[n, x] returns a polynomial in x in which the coefficient \
of x^m is the number of nonisomorphic graphs with n vertices and m edges. \
GraphPolynomial[n, x, Directed] returns a polynomial in x in which the \
coefficient of x^m is the number of nonisomorphic directed graphs with n \
vertices and m edges.", "synonyms" -> {}, "title" -> "GraphPolynomial", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/GraphPolynomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1919, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2542, 77, 53, 1, 70, "ObjectName",
 CellID->19328],
Cell[2598, 80, 1726, 52, 70, "Usage",
 CellID->10193]
}, Open  ]],
Cell[CellGroupData[{
Cell[4361, 137, 311, 9, 70, "SeeAlsoSection",
 CellID->31773],
Cell[4675, 148, 495, 17, 70, "SeeAlso",
 CellID->24623]
}, Open  ]],
Cell[CellGroupData[{
Cell[5207, 170, 318, 9, 70, "TutorialsSection",
 CellID->333162408],
Cell[5528, 181, 186, 4, 70, "Tutorials",
 CellID->94391750]
}, Open  ]],
Cell[CellGroupData[{
Cell[5751, 190, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6073, 201, 157, 3, 70, "MoreAbout",
 CellID->442821177]
}, Open  ]],
Cell[6245, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

