(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7078,        230]
NotebookOptionsPosition[      5259,        175]
NotebookOutlinePosition[      6452,        206]
CellTagsIndexPosition[      6409,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BipartiteMatchingAndCover" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/BipartiteMatchingAndCover"], 
          "VertexCover" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/VertexCover"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BipartiteMatchingAndCover\"\>", 
       2->"\<\"VertexCover\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GreedyVertexCover", "ObjectName",
 CellID->8210],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GreedyVertexCover", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a vertex cover of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " constructed using the greedy algorithm. This is a natural heuristic \
for constructing a vertex cover, but it can produce poor vertex covers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24879]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18638],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BipartiteMatchingAndCover",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/BipartiteMatchingAndCover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexCover",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/VertexCover"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7403]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->195034041],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->303707770]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->120092045]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GreedyVertexCover - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 20.2124950}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "GreedyVertexCover[g] returns a vertex cover of graph g constructed using \
the greedy algorithm. This is a natural heuristic for constructing a vertex \
cover, but it can produce poor vertex covers.", "synonyms" -> {}, "title" -> 
    "GreedyVertexCover", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/GreedyVertexCover"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1984, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2607, 79, 54, 1, 70, "ObjectName",
 CellID->8210],
Cell[2664, 82, 617, 16, 70, "Usage",
 CellID->24879]
}, Open  ]],
Cell[CellGroupData[{
Cell[3318, 103, 311, 9, 70, "SeeAlsoSection",
 CellID->18638],
Cell[3632, 114, 518, 17, 70, "SeeAlso",
 CellID->7403]
}, Open  ]],
Cell[CellGroupData[{
Cell[4187, 136, 318, 9, 70, "TutorialsSection",
 CellID->195034041],
Cell[4508, 147, 187, 4, 70, "Tutorials",
 CellID->303707770]
}, Open  ]],
Cell[CellGroupData[{
Cell[4732, 156, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5054, 167, 163, 3, 70, "MoreAbout",
 CellID->120092045]
}, Open  ]],
Cell[5232, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

