(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6570,        223]
NotebookOptionsPosition[      4942,        171]
NotebookOutlinePosition[      5946,        199]
CellTagsIndexPosition[      5903,        196]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HeapSort" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/HeapSort"], 
          "RandomHeap" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RandomHeap"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"HeapSort\"\>", 
       2->"\<\"RandomHeap\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/Permutations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Heapify", "ObjectName",
 CellID->29415],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Heapify", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]builds a heap from permutation ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6146],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HeapSort",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HeapSort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomHeap",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomHeap"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17849]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->214482296],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->85997519]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutations",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/Permutations"]], "MoreAbout",
 CellID->147546236]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Heapify - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 30.4158812}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Heapify[p] builds a heap from permutation p.", "synonyms" -> {}, "title" -> 
    "Heapify", "type" -> "Symbol", "uri" -> "Combinatorica/ref/Heapify"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1879, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2502, 76, 45, 1, 70, "ObjectName",
 CellID->29415],
Cell[2550, 79, 464, 15, 70, "Usage",
 CellID->2922]
}, Open  ]],
Cell[CellGroupData[{
Cell[3051, 99, 310, 9, 70, "SeeAlsoSection",
 CellID->6146],
Cell[3364, 110, 483, 17, 70, "SeeAlso",
 CellID->17849]
}, Open  ]],
Cell[CellGroupData[{
Cell[3884, 132, 318, 9, 70, "TutorialsSection",
 CellID->214482296],
Cell[4205, 143, 186, 4, 70, "Tutorials",
 CellID->85997519]
}, Open  ]],
Cell[CellGroupData[{
Cell[4428, 152, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4750, 163, 150, 3, 70, "MoreAbout",
 CellID->147546236]
}, Open  ]],
Cell[4915, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

