(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7528,        248]
NotebookOptionsPosition[      5787,        193]
NotebookOutlinePosition[      6840,        222]
CellTagsIndexPosition[      6797,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromCycles" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/FromCycles"], 
          "RevealCycles" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RevealCycles"], 
          "ToCycles" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ToCycles"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FromCycles\"\>", 
       2->"\<\"RevealCycles\"\>", 3->"\<\"ToCycles\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsets and Cycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndCycles"], 
          "Subsets and Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndPermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subsets and Cycles\"\>", 
       2->"\<\"Subsets and Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HideCycles", "ObjectName",
 CellID->15797],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"HideCycles", "[", 
       StyleBox["c", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]canonically encodes the cycle structure ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " into a unique permutation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6096]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14359],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromCycles",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromCycles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RevealCycles",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RevealCycles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCycles",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToCycles"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16286]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->207542688],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->504820597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "MoreAbout",
 CellID->221783821],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "MoreAbout",
 CellID->21199295]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HideCycles - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 32.2128022}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "HideCycles[c] canonically encodes the cycle structure c into a unique \
permutation.", "synonyms" -> {}, "title" -> "HideCycles", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/HideCycles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2227, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2850, 83, 48, 1, 70, "ObjectName",
 CellID->15797],
Cell[2901, 86, 502, 15, 70, "Usage",
 CellID->6096]
}, Open  ]],
Cell[CellGroupData[{
Cell[3440, 106, 311, 9, 70, "SeeAlsoSection",
 CellID->14359],
Cell[3754, 117, 750, 26, 70, "SeeAlso",
 CellID->16286]
}, Open  ]],
Cell[CellGroupData[{
Cell[4541, 148, 318, 9, 70, "TutorialsSection",
 CellID->207542688],
Cell[4862, 159, 187, 4, 70, "Tutorials",
 CellID->504820597]
}, Open  ]],
Cell[CellGroupData[{
Cell[5086, 168, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5408, 179, 160, 3, 70, "MoreAbout",
 CellID->221783821],
Cell[5571, 184, 174, 4, 70, "MoreAbout",
 CellID->21199295]
}, Open  ]],
Cell[5760, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

