(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7149,        236]
NotebookOptionsPosition[      5391,        181]
NotebookOutlinePosition[      6462,        210]
CellTagsIndexPosition[      6419,        207]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inversions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Inversions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Inversions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutations" :> 
          Documentation`HelpLookup["paclet:Combinatorica/guide/Permutations"],
           "Subsets and Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndPermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Permutations\"\>", 
       2->"\<\"Subsets and Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Index", "ObjectName",
 CellID->18954],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Index", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the index of permutation ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     ", the sum of all subscripts ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " such that ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
       TraditionalForm]], "InlineMath"],
     " is greater than ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "\[LeftDoubleBracket]", 
        RowBox[{"j", "+", "1"}], "\[RightDoubleBracket]"}], TraditionalForm]],
       "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2017]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29072],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Inversions",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Inversions"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->26739]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->242614383],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->940195907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutations",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/Permutations"]], "MoreAbout",
 CellID->49141988],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "MoreAbout",
 CellID->116497372]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Index - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 43.9318522}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Index[p] gives the index of permutation p, the sum of all subscripts j \
such that p[[j]] is greater than p[[j + 1]].", "synonyms" -> {}, "title" -> 
    "Index", "type" -> "Symbol", "uri" -> "Combinatorica/ref/Index"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1935, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2558, 77, 43, 1, 70, "ObjectName",
 CellID->18954],
Cell[2604, 80, 949, 29, 70, "Usage",
 CellID->2017]
}, Open  ]],
Cell[CellGroupData[{
Cell[3590, 114, 311, 9, 70, "SeeAlsoSection",
 CellID->29072],
Cell[3904, 125, 214, 6, 70, "SeeAlso",
 CellID->26739]
}, Open  ]],
Cell[CellGroupData[{
Cell[4155, 136, 318, 9, 70, "TutorialsSection",
 CellID->242614383],
Cell[4476, 147, 187, 4, 70, "Tutorials",
 CellID->940195907]
}, Open  ]],
Cell[CellGroupData[{
Cell[4700, 156, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5022, 167, 149, 3, 70, "MoreAbout",
 CellID->49141988],
Cell[5174, 172, 175, 4, 70, "MoreAbout",
 CellID->116497372]
}, Open  ]],
Cell[5364, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

