(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7794,        252]
NotebookOptionsPosition[      5922,        197]
NotebookOutlinePosition[      7169,        228]
CellTagsIndexPosition[      7126,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConstructTableau" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ConstructTableau"], "DeleteFromTableau" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DeleteFromTableau"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ConstructTableau\"\>", 
       2->"\<\"DeleteFromTableau\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InsertIntoTableau", "ObjectName",
 CellID->4191],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InsertIntoTableau", "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts integer ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " into Young tableau ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " using the bumping algorithm. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InsertIntoTableau", "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " into Young tableau ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " and returns the new tableau as well as the row whose size is expanded \
as a result of the insertion."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4754]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3225],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConstructTableau",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ConstructTableau"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteFromTableau",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeleteFromTableau"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16825]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21918611],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->227081370]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->274577845]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InsertIntoTableau - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 44.8850016}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "InsertIntoTableau[e, t] inserts integer e into Young tableau t using the \
bumping algorithm. InsertIntoTableau[e, t, All] inserts e into Young tableau \
t and returns the new tableau as well as the row whose size is expanded as a \
result of the insertion.", "synonyms" -> {}, "title" -> "InsertIntoTableau", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/InsertIntoTableau"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1987, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2610, 78, 54, 1, 70, "ObjectName",
 CellID->4191],
Cell[2667, 81, 1266, 38, 70, "Usage",
 CellID->4754]
}, Open  ]],
Cell[CellGroupData[{
Cell[3970, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->3225],
Cell[4283, 135, 513, 17, 70, "SeeAlso",
 CellID->16825]
}, Open  ]],
Cell[CellGroupData[{
Cell[4833, 157, 317, 9, 70, "TutorialsSection",
 CellID->21918611],
Cell[5153, 168, 187, 4, 70, "Tutorials",
 CellID->227081370]
}, Open  ]],
Cell[CellGroupData[{
Cell[5377, 177, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5699, 188, 181, 4, 70, "MoreAbout",
 CellID->274577845]
}, Open  ]],
Cell[5895, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

