(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7819,        255]
NotebookOptionsPosition[      5937,        199]
NotebookOutlinePosition[      7190,        231]
CellTagsIndexPosition[      7147,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DistinctPermutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DistinctPermutations"], "InvolutionQ" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/InvolutionQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DistinctPermutations\"\>", 
       2->"\<\"InvolutionQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/Permutations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Involutions", "ObjectName",
 CellID->16199],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Involutions", "[", 
       StyleBox["l", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of involutions of the elements in the \
list ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Involutions", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", "Cycles"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the involutions in their cycle representation. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Involution", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives size-",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " involutions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Involutions", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", "Cycles"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives size-",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " involutions in their cycle representation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15598]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15772],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DistinctPermutations",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DistinctPermutations"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InvolutionQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/InvolutionQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->215908024],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->578857368]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutations",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/Permutations"]], "MoreAbout",
 CellID->135378086]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Involutions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 51.8070538}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Involutions[l] gives the list of involutions of the elements in the list \
l. Involutions[l, Cycles] gives the involutions in their cycle \
representation. Involution[n] gives size-n involutions. Involutions[n, \
Cycles] gives size-n involutions in their cycle representation.", 
    "synonyms" -> {}, "title" -> "Involutions", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Involutions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1930, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2553, 77, 49, 1, 70, "ObjectName",
 CellID->16199],
Cell[2605, 80, 1376, 42, 70, "Usage",
 CellID->15598]
}, Open  ]],
Cell[CellGroupData[{
Cell[4018, 127, 311, 9, 70, "SeeAlsoSection",
 CellID->15772],
Cell[4332, 138, 509, 17, 70, "SeeAlso",
 CellID->12793]
}, Open  ]],
Cell[CellGroupData[{
Cell[4878, 160, 318, 9, 70, "TutorialsSection",
 CellID->215908024],
Cell[5199, 171, 187, 4, 70, "Tutorials",
 CellID->578857368]
}, Open  ]],
Cell[CellGroupData[{
Cell[5423, 180, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5745, 191, 150, 3, 70, "MoreAbout",
 CellID->135378086]
}, Open  ]],
Cell[5910, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

