(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7908,        257]
NotebookOptionsPosition[      6050,        202]
NotebookOutlinePosition[      7280,        233]
CellTagsIndexPosition[      7237,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RandomKSetPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RandomKSetPartition"], "SetPartitions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SetPartitions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RandomKSetPartition\"\>", 
       2->"\<\"SetPartitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KSetPartitions", "ObjectName",
 CellID->22704],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KSetPartitions", "[", 
       RowBox[{
        StyleBox["set", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the list of set partitions of ",
     Cell[BoxData[
      StyleBox["set", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " blocks. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KSetPartitions", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the list of set partitions of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " with ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " blocks. If all set partitions of a set are needed, use the function ",
     Cell[BoxData[
      ButtonBox["SetPartitions",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/SetPartitions"]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32134],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomKSetPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomKSetPartition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SetPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28406]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->280187991],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->462010788]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->45452947]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KSetPartitions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 58.5572266}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "KSetPartitions[set, k] returns the list of set partitions of set with k \
blocks. KSetPartitions[n, k] returns the list of set partitions of {1, 2, \
..., n} with k blocks. If all set partitions of a set are needed, use the \
function SetPartitions.", "synonyms" -> {}, "title" -> "KSetPartitions", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/KSetPartitions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1984, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2607, 78, 52, 1, 70, "ObjectName",
 CellID->22704],
Cell[2662, 81, 1400, 43, 70, "Usage",
 CellID->20588]
}, Open  ]],
Cell[CellGroupData[{
Cell[4099, 129, 311, 9, 70, "SeeAlsoSection",
 CellID->32134],
Cell[4413, 140, 511, 17, 70, "SeeAlso",
 CellID->28406]
}, Open  ]],
Cell[CellGroupData[{
Cell[4961, 162, 318, 9, 70, "TutorialsSection",
 CellID->280187991],
Cell[5282, 173, 187, 4, 70, "Tutorials",
 CellID->462010788]
}, Open  ]],
Cell[CellGroupData[{
Cell[5506, 182, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5828, 193, 180, 4, 70, "MoreAbout",
 CellID->45452947]
}, Open  ]],
Cell[6023, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

