(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7200,        236]
NotebookOptionsPosition[      5378,        181]
NotebookOutlinePosition[      6573,        212]
CellTagsIndexPosition[      6530,        209]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GridGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GridGraph"], 
          "HamiltonianCycle" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/HamiltonianCycle"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GridGraph\"\>", 
       2->"\<\"HamiltonianCycle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KnightsTourGraph", "ObjectName",
 CellID->11110],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KnightsTourGraph", "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a graph with ",
     Cell[BoxData[
      StyleBox["mn", "TI"]], "InlineFormula"],
     " vertices in which each vertex represents a square in an ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     "\[Times]",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " chessboard and each edge corresponds to a legal move by a knight from \
one square to another."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17405]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22319],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GridGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HamiltonianCycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HamiltonianCycle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->658277843],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->78663172]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->232976894]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KnightsTourGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 58.3853472}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "KnightsTourGraph[m, n] returns a graph with mn vertices in which each \
vertex represents a square in an m*n chessboard and each edge corresponds to \
a legal move by a knight from one square to another.", "synonyms" -> {}, 
    "title" -> "KnightsTourGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/KnightsTourGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1918, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2541, 77, 54, 1, 70, "ObjectName",
 CellID->11110],
Cell[2598, 80, 833, 24, 70, "Usage",
 CellID->17405]
}, Open  ]],
Cell[CellGroupData[{
Cell[3468, 109, 311, 9, 70, "SeeAlsoSection",
 CellID->22319],
Cell[3782, 120, 497, 17, 70, "SeeAlso",
 CellID->12736]
}, Open  ]],
Cell[CellGroupData[{
Cell[4316, 142, 318, 9, 70, "TutorialsSection",
 CellID->658277843],
Cell[4637, 153, 186, 4, 70, "Tutorials",
 CellID->78663172]
}, Open  ]],
Cell[CellGroupData[{
Cell[4860, 162, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5182, 173, 154, 3, 70, "MoreAbout",
 CellID->232976894]
}, Open  ]],
Cell[5351, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

