(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7588,        248]
NotebookOptionsPosition[      5737,        192]
NotebookOutlinePosition[      6899,        222]
CellTagsIndexPosition[      6856,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NthSubset" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/NthSubset"], 
          "Subsets" :> Documentation`HelpLookup["paclet:ref/Subsets"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"NthSubset\"\>", 
       2->"\<\"Subsets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsets and Cycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndCycles"], 
          "Subsets and Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndPermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subsets and Cycles\"\>", 
       2->"\<\"Subsets and Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LexicographicSubsets", "ObjectName",
 CellID->21521],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LexicographicSubsets", "[", 
       StyleBox["l", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all subsets of set ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " in lexicographic order. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LexicographicSubsets", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns all subsets of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " in lexicographic order."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->13249]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17935],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NthSubset",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NthSubset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7049048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->274024801],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->663988790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "MoreAbout",
 CellID->9246314],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "MoreAbout",
 CellID->68344853]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LexicographicSubsets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 6.3855520}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "LexicographicSubsets[l] gives all subsets of set l in lexicographic \
order. LexicographicSubsets[n] returns all subsets of {1, 2, ..., n} in \
lexicographic order.", "synonyms" -> {}, "title" -> "LexicographicSubsets", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/LexicographicSubsets"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2054, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2677, 79, 58, 1, 70, "ObjectName",
 CellID->21521],
Cell[2738, 82, 900, 27, 70, "Usage",
 CellID->13249]
}, Open  ]],
Cell[CellGroupData[{
Cell[3675, 114, 311, 9, 70, "SeeAlsoSection",
 CellID->17935],
Cell[3989, 125, 467, 17, 70, "SeeAlso",
 CellID->7049048]
}, Open  ]],
Cell[CellGroupData[{
Cell[4493, 147, 318, 9, 70, "TutorialsSection",
 CellID->274024801],
Cell[4814, 158, 187, 4, 70, "Tutorials",
 CellID->663988790]
}, Open  ]],
Cell[CellGroupData[{
Cell[5038, 167, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5360, 178, 158, 3, 70, "MoreAbout",
 CellID->9246314],
Cell[5521, 183, 174, 4, 70, "MoreAbout",
 CellID->68344853]
}, Open  ]],
Cell[5710, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

