(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8174,        260]
NotebookOptionsPosition[      6144,        202]
NotebookOutlinePosition[      7547,        236]
CellTagsIndexPosition[      7504,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NecklacePolynomial" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NecklacePolynomial"], 
          "NumberOfNecklaces" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NumberOfNecklaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NecklacePolynomial\"\>", 
       2->"\<\"NumberOfNecklaces\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ListNecklaces", "ObjectName",
 CellID->18054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListNecklaces", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["c", "TI"], ",", 
        ButtonBox["Cyclic",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Cyclic"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns all distinct necklaces whose beads are colored \
by colors from ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     ". Here ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " is a list of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     ", not necessarily distinct colors, and two colored necklaces are \
considered equivalent if one can be obtained by rotating the other. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ListNecklaces", "["}], 
         StyleBox["n", "TI"]}], ",", 
        StyleBox["c", "TI"], ",", 
        ButtonBox["Dihedral",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Dihedral"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]is similar except that two necklaces are considered \
equivalent if one can be obtained from the other by a rotation or a flip."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24657]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2998],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NecklacePolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NecklacePolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfNecklaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NumberOfNecklaces"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16060]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->258774461],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->61044059]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->397169723]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListNecklaces - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 6.9793172}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ListNecklaces[n, c, Cyclic] returns all distinct necklaces whose beads \
are colored by colors from c. Here c is a list of n, not necessarily distinct \
colors, and two colored necklaces are considered equivalent if one can be \
obtained by rotating the other. ListNecklaces[ n, c, Dihedral] is similar \
except that two necklaces are considered equivalent if one can be obtained \
from the other by a rotation or a flip.", "synonyms" -> {}, "title" -> 
    "ListNecklaces", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ListNecklaces"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1964, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2587, 78, 51, 1, 70, "ObjectName",
 CellID->18054],
Cell[2641, 81, 1534, 44, 70, "Usage",
 CellID->24657]
}, Open  ]],
Cell[CellGroupData[{
Cell[4212, 130, 310, 9, 70, "SeeAlsoSection",
 CellID->2998],
Cell[4525, 141, 517, 17, 70, "SeeAlso",
 CellID->16060]
}, Open  ]],
Cell[CellGroupData[{
Cell[5079, 163, 318, 9, 70, "TutorialsSection",
 CellID->258774461],
Cell[5400, 174, 186, 4, 70, "Tutorials",
 CellID->61044059]
}, Open  ]],
Cell[CellGroupData[{
Cell[5623, 183, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5945, 194, 157, 3, 70, "MoreAbout",
 CellID->397169723]
}, Open  ]],
Cell[6117, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

