(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10761,        364]
NotebookOptionsPosition[      8602,        296]
NotebookOutlinePosition[      9766,        327]
CellTagsIndexPosition[      9723,        324]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FunctionalGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FunctionalGraph"], "IntervalGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/IntervalGraph"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FunctionalGraph\"\>", 
       2->"\<\"IntervalGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Constructing Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MakeGraph", "ObjectName",
 CellID->15296],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MakeGraph", "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs the graph whose vertices correspond to ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " and edges between pairs of vertices ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " for which the binary relation defined by the Boolean function ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11364]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MakeGraph"], "InlineFormula"],
 " takes two options, ",
 Cell[BoxData["Type"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31441],

Cell[TextData[{
 Cell[BoxData["Type"], "InlineFormula"],
 " can be set to ",
 Cell[BoxData[
  ButtonBox["Directed",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Undirected",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
 " and this tells ",
 Cell[BoxData["MakeGraph"], "InlineFormula"],
 " whether to construct a directed or an undirected graph. The default \
setting is ",
 Cell[BoxData[
  ButtonBox["Directed",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->999340],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 " can be set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " being the default setting. Using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/VertexLabel"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " assigns labels derived from ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " to the vertices of the graph."
}], "Notes",
 CellID->154024825]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13901],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionalGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FunctionalGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/IntervalGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29169]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3453931],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->257698248]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->634657356],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->346658515]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MakeGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 14.7920172}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "MakeGraph[v, f] constructs the graph whose vertices correspond to v and \
edges between pairs of vertices x and y in v for which the binary relation \
defined by the Boolean function f is True.", "synonyms" -> {}, "title" -> 
    "MakeGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/MakeGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2167, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2790, 82, 47, 1, 70, "ObjectName",
 CellID->15296],
Cell[2840, 85, 1113, 34, 70, "Usage",
 CellID->11364]
}, Open  ]],
Cell[CellGroupData[{
Cell[3990, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4468, 141, 311, 11, 70, "Notes",
 CellID->31441],
Cell[4782, 154, 678, 22, 70, "Notes",
 CellID->999340],
Cell[5463, 178, 971, 34, 70, "Notes",
 CellID->154024825]
}, Closed]],
Cell[CellGroupData[{
Cell[6471, 217, 311, 9, 70, "SeeAlsoSection",
 CellID->13901],
Cell[6785, 228, 503, 17, 70, "SeeAlso",
 CellID->29169]
}, Open  ]],
Cell[CellGroupData[{
Cell[7325, 250, 316, 9, 70, "TutorialsSection",
 CellID->3453931],
Cell[7644, 261, 187, 4, 70, "Tutorials",
 CellID->257698248]
}, Open  ]],
Cell[CellGroupData[{
Cell[7868, 270, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[8190, 281, 163, 3, 70, "MoreAbout",
 CellID->634657356],
Cell[8356, 286, 204, 5, 70, "MoreAbout",
 CellID->346658515]
}, Open  ]],
Cell[8575, 294, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

