(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6821,        227]
NotebookOptionsPosition[      5113,        174]
NotebookOutlinePosition[      6196,        203]
CellTagsIndexPosition[      6153,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChromaticNumber" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ChromaticNumber"], "Harary" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Harary"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ChromaticNumber\"\>", 
       2->"\<\"Harary\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MycielskiGraph", "ObjectName",
 CellID->17045],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MycielskiGraph", "[", 
       StyleBox["k", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns a triangle-free graph with chromatic number ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     ", for any positive integer ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22927]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5074],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChromaticNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ChromaticNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Harary",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Harary"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4950]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->419234463],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->262563376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->26813959]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MycielskiGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 30.5580458}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "MycielskiGraph[k] returns a triangle-free graph with chromatic number k, \
for any positive integer k.", "synonyms" -> {}, "title" -> "MycielskiGraph", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/MycielskiGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1896, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2519, 76, 52, 1, 70, "ObjectName",
 CellID->17045],
Cell[2574, 79, 602, 18, 70, "Usage",
 CellID->22927]
}, Open  ]],
Cell[CellGroupData[{
Cell[3213, 102, 310, 9, 70, "SeeAlsoSection",
 CellID->5074],
Cell[3526, 113, 488, 17, 70, "SeeAlso",
 CellID->4950]
}, Open  ]],
Cell[CellGroupData[{
Cell[4051, 135, 318, 9, 70, "TutorialsSection",
 CellID->419234463],
Cell[4372, 146, 187, 4, 70, "Tutorials",
 CellID->262563376]
}, Open  ]],
Cell[CellGroupData[{
Cell[4596, 155, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4918, 166, 153, 3, 70, "MoreAbout",
 CellID->26813959]
}, Open  ]],
Cell[5086, 172, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

