(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10724,        349]
NotebookOptionsPosition[      8462,        284]
NotebookOutlinePosition[      9907,        318]
CellTagsIndexPosition[      9864,        315]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EdgeConnectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/EdgeConnectivity"], "NetworkFlowEdges" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NetworkFlowEdges"], "VertexConnectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/VertexConnectivity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EdgeConnectivity\"\>", 
       2->"\<\"NetworkFlowEdges\"\>", 
       3->"\<\"VertexConnectivity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NetworkFlow", "ObjectName",
 CellID->18684],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NetworkFlow", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["source", "TI"], ",", 
        StyleBox["sink", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the value of a maximum flow through graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " from ",
     Cell[BoxData[
      StyleBox["source", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["sink", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NetworkFlow", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["source", "TI"], ",", 
        StyleBox["sink", "TI"], ",", 
        ButtonBox["Edge",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Edge"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns the edges in ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " that have positive flow along with their flows in a maximum flow from \
",
     Cell[BoxData[
      StyleBox["source", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["sink", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NetworkFlow", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["source", "TI"], ",", 
        StyleBox["sink", "TI"], ",", 
        ButtonBox["Cut",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Cut"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns a minimum cut between ",
     Cell[BoxData[
      StyleBox["source", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["sink", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NetworkFlow", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["source", "TI"], ",", 
        StyleBox["sink", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the adjacency list of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " along with flows on each edge in a maximum flow from ",
     Cell[BoxData[
      StyleBox["source", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["sink", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->30391]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The graph ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " can be a directed or an undirected graph."
}], "Notes",
 CellID->1311]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27770],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeConnectivity",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/EdgeConnectivity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NetworkFlowEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NetworkFlowEdges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexConnectivity",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/VertexConnectivity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->594082754],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->136554616]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->51113133]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NetworkFlow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 31.2768142}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "NetworkFlow[g, source, sink] returns the value of a maximum flow through \
graph g from source to sink. NetworkFlow[g, source, sink, Edge] returns the \
edges in g that have positive flow along with their flows in a maximum flow \
from source to sink. NetworkFlow[g, source, sink, Cut] returns a minimum cut \
between source and sink. NetworkFlow[g, source, sink, All] returns the \
adjacency list of g along with flows on each edge in a maximum flow from \
source to sink.", "synonyms" -> {}, "title" -> "NetworkFlow", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/NetworkFlow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2105, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2728, 80, 49, 1, 70, "ObjectName",
 CellID->18684],
Cell[2780, 83, 2756, 87, 70, "Usage",
 CellID->30391]
}, Open  ]],
Cell[CellGroupData[{
Cell[5573, 175, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6051, 192, 168, 6, 70, "Notes",
 CellID->1311]
}, Closed]],
Cell[CellGroupData[{
Cell[6256, 203, 311, 9, 70, "SeeAlsoSection",
 CellID->27770],
Cell[6570, 214, 790, 26, 70, "SeeAlso",
 CellID->27845]
}, Open  ]],
Cell[CellGroupData[{
Cell[7397, 245, 318, 9, 70, "TutorialsSection",
 CellID->594082754],
Cell[7718, 256, 187, 4, 70, "Tutorials",
 CellID->136554616]
}, Open  ]],
Cell[CellGroupData[{
Cell[7942, 265, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[8264, 276, 156, 3, 70, "MoreAbout",
 CellID->51113133]
}, Open  ]],
Cell[8435, 282, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

