(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6842,        229]
NotebookOptionsPosition[      5161,        176]
NotebookOutlinePosition[      6215,        205]
CellTagsIndexPosition[      6172,        202]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RandomTableau" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RandomTableau"], 
          "Tableaux" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Tableaux"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"RandomTableau\"\>", 
       2->"\<\"Tableaux\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NextTableau", "ObjectName",
 CellID->12384],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NextTableau", "[", 
       StyleBox["t", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the tableau of shape ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     ", following ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " in lexicographic order."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10463]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26051],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomTableau",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomTableau"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tableaux",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Tableaux"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8314]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->233580184],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->166539902]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->764932304]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NextTableau - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 39.2145174}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "NextTableau[t] gives the tableau of shape t, following t in \
lexicographic order.", "synonyms" -> {}, "title" -> "NextTableau", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/NextTableau"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1939, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2562, 77, 49, 1, 70, "ObjectName",
 CellID->12384],
Cell[2614, 80, 581, 18, 70, "Usage",
 CellID->10463]
}, Open  ]],
Cell[CellGroupData[{
Cell[3232, 103, 311, 9, 70, "SeeAlsoSection",
 CellID->26051],
Cell[3546, 114, 488, 17, 70, "SeeAlso",
 CellID->8314]
}, Open  ]],
Cell[CellGroupData[{
Cell[4071, 136, 318, 9, 70, "TutorialsSection",
 CellID->233580184],
Cell[4392, 147, 187, 4, 70, "Tutorials",
 CellID->166539902]
}, Open  ]],
Cell[CellGroupData[{
Cell[4616, 156, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4938, 167, 181, 4, 70, "MoreAbout",
 CellID->764932304]
}, Open  ]],
Cell[5134, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

