(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8281,        259]
NotebookOptionsPosition[      6191,        201]
NotebookOutlinePosition[      7652,        235]
CellTagsIndexPosition[      7609,        232]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListNecklaces" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ListNecklaces"], 
          "NecklacePolynomial" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NecklacePolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListNecklaces\"\>", 
       2->"\<\"NecklacePolynomial\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberOfNecklaces", "ObjectName",
 CellID->24511],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NumberOfNecklaces", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["nc", "TI"], ",", 
        ButtonBox["Cyclic",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Cyclic"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns the number of distinct ways in which an ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "-bead necklace can be colored with ",
     Cell[BoxData[
      StyleBox["nc", "TI"]], "InlineFormula"],
     " colors, assuming that two colorings are equivalent if one can be \
obtained from the other by a rotation. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NumberOfNecklaces", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["nc", "TI"], ",", 
        ButtonBox["Dihedral",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Dihedral"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns the number of distinct ways in which an ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "-bead necklace can be colored with ",
     Cell[BoxData[
      StyleBox["nc", "TI"]], "InlineFormula"],
     " colors, assuming that two colorings are equivalent if one can be \
obtained from the other by a rotation or a flip."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23160]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13258],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListNecklaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ListNecklaces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NecklacePolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NecklacePolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30960]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->106333031],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->667118711]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->495108495]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberOfNecklaces - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 54.9805460}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "NumberOfNecklaces[n, nc, Cyclic] returns the number of distinct ways in \
which an n-bead necklace can be colored with nc colors, assuming that two \
colorings are equivalent if one can be obtained from the other by a rotation. \
NumberOfNecklaces[n, nc, Dihedral] returns the number of distinct ways in \
which an n-bead necklace can be colored with nc colors, assuming that two \
colorings are equivalent if one can be obtained from the other by a rotation \
or a flip.", "synonyms" -> {}, "title" -> "NumberOfNecklaces", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/NumberOfNecklaces"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1940, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2563, 77, 55, 1, 70, "ObjectName",
 CellID->24511],
Cell[2621, 80, 1607, 44, 70, "Usage",
 CellID->23160]
}, Open  ]],
Cell[CellGroupData[{
Cell[4265, 129, 311, 9, 70, "SeeAlsoSection",
 CellID->13258],
Cell[4579, 140, 509, 17, 70, "SeeAlso",
 CellID->30960]
}, Open  ]],
Cell[CellGroupData[{
Cell[5125, 162, 318, 9, 70, "TutorialsSection",
 CellID->106333031],
Cell[5446, 173, 187, 4, 70, "Tutorials",
 CellID->667118711]
}, Open  ]],
Cell[CellGroupData[{
Cell[5670, 182, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5992, 193, 157, 3, 70, "MoreAbout",
 CellID->495108495]
}, Open  ]],
Cell[6164, 199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

