(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8735,        294]
NotebookOptionsPosition[      6819,        232]
NotebookOutlinePosition[      7858,        261]
CellTagsIndexPosition[      7815,        258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrbitInventory" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/OrbitInventory"],
           "OrbitRepresentatives" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/OrbitRepresentatives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrbitInventory\"\>", 
       2->"\<\"OrbitRepresentatives\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"], 
          "Subsets and Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndPermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Permutation Groups\"\>", 
       2->"\<\"Subsets and Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Orbits", "ObjectName",
 CellID->30220],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Orbits", "[", 
       RowBox[{
        StyleBox["pg", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the orbits of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " induced by the action of the group ",
     Cell[BoxData[
      StyleBox["pg", "TI"]], "InlineFormula"],
     " on ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23733]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["pg", "TI"]], "InlineFormula"],
 " is assumed to be a set of permutations on the first ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " natural numbers and ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is a set of functions whose domain is the first ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " natural numbers. Each function in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is specified as an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "-tuple."
}], "Notes",
 CellID->3247]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19796],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrbitInventory",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrbitInventory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrbitRepresentatives",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrbitRepresentatives"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2197]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24807249],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->85891640]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->551973098],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "MoreAbout",
 CellID->608741347]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Orbits - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 3.6995192}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Orbits[pg, x] returns the orbits of x induced by the action of the group \
pg on x.", "synonyms" -> {}, "title" -> "Orbits", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Orbits"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2145, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2768, 81, 44, 1, 70, "ObjectName",
 CellID->30220],
Cell[2815, 84, 706, 23, 70, "Usage",
 CellID->23733]
}, Open  ]],
Cell[CellGroupData[{
Cell[3558, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4036, 129, 635, 20, 70, "Notes",
 CellID->3247]
}, Closed]],
Cell[CellGroupData[{
Cell[4708, 154, 311, 9, 70, "SeeAlsoSection",
 CellID->19796],
Cell[5022, 165, 514, 17, 70, "SeeAlso",
 CellID->2197]
}, Open  ]],
Cell[CellGroupData[{
Cell[5573, 187, 317, 9, 70, "TutorialsSection",
 CellID->24807249],
Cell[5893, 198, 186, 4, 70, "Tutorials",
 CellID->85891640]
}, Open  ]],
Cell[CellGroupData[{
Cell[6116, 207, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6438, 218, 161, 3, 70, "MoreAbout",
 CellID->551973098],
Cell[6602, 223, 175, 4, 70, "MoreAbout",
 CellID->608741347]
}, Open  ]],
Cell[6792, 230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

