(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10018,        317]
NotebookOptionsPosition[      7817,        257]
NotebookOutlinePosition[      9392,        293]
CellTagsIndexPosition[      9349,        290]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrbitInventory" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/OrbitInventory"],
           "SymmetricGroupIndex" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SymmetricGroupIndex"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrbitInventory\"\>", 
       2->"\<\"SymmetricGroupIndex\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Permutation Groups\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PairGroupIndex", "ObjectName",
 CellID->14257],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PairGroupIndex", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the cycle index of the pair group induced by ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " as a polynomial in ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], ",", 
        RowBox[{"x", "[", "2", "]"}], ",", "\[Ellipsis]"}], TraditionalForm]],
       "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PairGroupIndex", "[", 
       RowBox[{
        StyleBox["ci", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the cycle index ",
     Cell[BoxData[
      StyleBox["ci", "TI"]], "InlineFormula"],
     " of a group ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with formal variables ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], ",", 
        RowBox[{"x", "[", "2", "]"}], ",", "\[Ellipsis]"}], TraditionalForm]],
       "InlineMath"],
     ", and returns the cycle index of the pair group induced by ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PairGroupIndex", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        ButtonBox["Ordered",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Ordered"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns the cycle index of the ordered pair group \
induced by ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " as a polynomial in ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], ",", 
        RowBox[{"x", "[", "2", "]"}], ",", "\[Ellipsis]"}], TraditionalForm]],
       "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PairGroupIndex", "[", 
       RowBox[{
        StyleBox["ci", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        ButtonBox["Ordered",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Ordered"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]takes the cycle index ",
     Cell[BoxData[
      StyleBox["ci", "TI"]], "InlineFormula"],
     " of a group ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with formal variables ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], ",", 
        RowBox[{"x", "[", "2", "]"}], ",", "\[Ellipsis]"}], TraditionalForm]],
       "InlineMath"],
     ", and returns the cycle index of the ordered pair group induced by ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6746]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28871],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrbitInventory",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrbitInventory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymmetricGroupIndex",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SymmetricGroupIndex"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4106]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->149197523],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->46053297]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->900380334]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PairGroupIndex - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 10.8715778}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "PairGroupIndex[g, x] returns the cycle index of the pair group induced \
by g as a polynomial in x[1], x[2], .... PairGroupIndex[ci, x] takes the \
cycle index ci of a group g with formal variables x[1], x[2], ..., and \
returns the cycle index of the pair group induced by g. PairGroupIndex[g, x, \
Ordered] returns the cycle index of the ordered pair group induced by g as a \
polynomial in x[1], x[2], .... PairGroupIndex[ci, x, Ordered] takes the cycle \
index ci of a group g with formal variables x[1], x[2], ..., and returns the \
cycle index of the ordered pair group induced by g.", "synonyms" -> {}, 
    "title" -> "PairGroupIndex", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/PairGroupIndex"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1960, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2583, 78, 52, 1, 70, "ObjectName",
 CellID->14257],
Cell[2638, 81, 3210, 99, 70, "Usage",
 CellID->6746]
}, Open  ]],
Cell[CellGroupData[{
Cell[5885, 185, 311, 9, 70, "SeeAlsoSection",
 CellID->28871],
Cell[6199, 196, 512, 17, 70, "SeeAlso",
 CellID->4106]
}, Open  ]],
Cell[CellGroupData[{
Cell[6748, 218, 318, 9, 70, "TutorialsSection",
 CellID->149197523],
Cell[7069, 229, 186, 4, 70, "Tutorials",
 CellID->46053297]
}, Open  ]],
Cell[CellGroupData[{
Cell[7292, 238, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7614, 249, 161, 3, 70, "MoreAbout",
 CellID->900380334]
}, Open  ]],
Cell[7790, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

