(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7043,        238]
NotebookOptionsPosition[      5333,        184]
NotebookOutlinePosition[      6419,        214]
CellTagsIndexPosition[      6376,        211]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Partitions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Partitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PartitionQ", "ObjectName",
 CellID->1850],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionQ", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " is an integer partition. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionQ", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " is a partition of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9866]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13250],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Partitions",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Partitions"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->17522]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10346696],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->546802067]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->21302499]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PartitionQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 18.3873952}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "PartitionQ[p] yields True if p is an integer partition. PartitionQ[n, p] \
yields True if p is a partition of n.", "synonyms" -> {}, "title" -> 
    "PartitionQ", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/PartitionQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1808, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2431, 75, 47, 1, 70, "ObjectName",
 CellID->1850],
Cell[2481, 78, 1162, 39, 70, "Usage",
 CellID->9866]
}, Open  ]],
Cell[CellGroupData[{
Cell[3680, 122, 311, 9, 70, "SeeAlsoSection",
 CellID->13250],
Cell[3994, 133, 214, 6, 70, "SeeAlso",
 CellID->17522]
}, Open  ]],
Cell[CellGroupData[{
Cell[4245, 144, 317, 9, 70, "TutorialsSection",
 CellID->10346696],
Cell[4565, 155, 187, 4, 70, "Tutorials",
 CellID->546802067]
}, Open  ]],
Cell[CellGroupData[{
Cell[4789, 164, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5111, 175, 180, 4, 70, "MoreAbout",
 CellID->21302499]
}, Open  ]],
Cell[5306, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

