(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10976,        368]
NotebookOptionsPosition[      8848,        300]
NotebookOutlinePosition[      9919,        329]
CellTagsIndexPosition[      9876,        326]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExactRandomGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ExactRandomGraph"], 
          "RealizeDegreeSequence" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RealizeDegreeSequence"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExactRandomGraph\"\>", 
       2->"\<\"RealizeDegreeSequence\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"], "Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Built-in Graphs\"\>", 
       2->"\<\"Constructing Graphs\"\>", 
       3->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RandomGraph", "ObjectName",
 CellID->17813],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RandomGraph", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a random labeled graph on ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices with an edge probability of ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17536]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option ",
 Cell[BoxData["Type"], "InlineFormula"],
 " is provided, which can take on values ",
 Cell[BoxData[
  ButtonBox["Directed",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Undirected",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
 ", and whose default value is ",
 Cell[BoxData[
  ButtonBox["Undirected",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13103],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Type", "->", 
   ButtonBox["Directed",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Directed"]}]], "InlineFormula"],
 " produces a corresponding random directed graph. "
}], "Notes",
 CellID->834230213],

Cell[TextData[{
 "The usages ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal",
    ButtonNote->"ObsLink: Random -> RandomReal (RandomInteger)"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"], ",", 
    ButtonBox["Directed",
     BaseStyle->"Link",
     ButtonData->"paclet:Combinatorica/ref/Directed"]}], "]"}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal",
    ButtonNote->"ObsLink: Random -> RandomReal (RandomInteger)"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"], ",", 
    StyleBox["range", "TI"]}], "]"}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal",
    ButtonNote->"ObsLink: Random -> RandomReal (RandomInteger)"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"], ",", 
    StyleBox["range", "TI"], ",", 
    ButtonBox["Directed",
     BaseStyle->"Link",
     ButtonData->"paclet:Combinatorica/ref/Directed"]}], "]"}]], 
  "InlineFormula"],
 " are all obsolete. Use ",
 Cell[BoxData[
  ButtonBox["SetEdgeWeights",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/SetEdgeWeights"]], "InlineFormula"],
 " to set random edge weights."
}], "Notes",
 CellID->43241066]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29277],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExactRandomGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ExactRandomGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealizeDegreeSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RealizeDegreeSequence"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->160471615],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->530571251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->50269795],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->23597389],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->128528380]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 34.9034430}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RandomGraph[n, p] constructs a random labeled graph on n vertices with \
an edge probability of p. ", "synonyms" -> {}, "title" -> "RandomGraph", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/RandomGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2357, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2980, 86, 49, 1, 70, "ObjectName",
 CellID->17813],
Cell[3032, 89, 649, 20, 70, "Usage",
 CellID->17536]
}, Open  ]],
Cell[CellGroupData[{
Cell[3718, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4196, 131, 601, 20, 70, "Notes",
 CellID->13103],
Cell[4800, 153, 264, 8, 70, "Notes",
 CellID->834230213],
Cell[5067, 163, 1439, 48, 70, "Notes",
 CellID->43241066]
}, Closed]],
Cell[CellGroupData[{
Cell[6543, 216, 311, 9, 70, "SeeAlsoSection",
 CellID->29277],
Cell[6857, 227, 520, 17, 70, "SeeAlso",
 CellID->5745]
}, Open  ]],
Cell[CellGroupData[{
Cell[7414, 249, 318, 9, 70, "TutorialsSection",
 CellID->160471615],
Cell[7735, 260, 187, 4, 70, "Tutorials",
 CellID->530571251]
}, Open  ]],
Cell[CellGroupData[{
Cell[7959, 269, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[8281, 280, 153, 3, 70, "MoreAbout",
 CellID->50269795],
Cell[8437, 285, 162, 3, 70, "MoreAbout",
 CellID->23597389],
Cell[8602, 290, 204, 5, 70, "MoreAbout",
 CellID->128528380]
}, Open  ]],
Cell[8821, 298, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

