(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7572,        248]
NotebookOptionsPosition[      5717,        191]
NotebookOutlinePosition[      6889,        222]
CellTagsIndexPosition[      6846,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RankSubset" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RankSubset"], 
          "UnrankSubset" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/UnrankSubset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RankSubset\"\>", 
       2->"\<\"UnrankSubset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsets and Cycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndCycles"], 
          "Subsets and Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndPermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subsets and Cycles\"\>", 
       2->"\<\"Subsets and Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RankBinarySubset", "ObjectName",
 CellID->29995],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RankBinarySubset", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the rank of subset ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " of set ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " in the ordering of subsets of ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ", obtained by interpreting these subsets as binary string \
representations of integers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21043]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->373],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RankSubset",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RankSubset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnrankSubset",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/UnrankSubset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->118]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24121758],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->15462036]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "MoreAbout",
 CellID->575880918],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "MoreAbout",
 CellID->41784928]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RankBinarySubset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 50.3725890}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RankBinarySubset[l, s] gives the rank of subset s of set l in the \
ordering of subsets of l, obtained by interpreting these subsets as binary \
string representations of integers.", "synonyms" -> {}, "title" -> 
    "RankBinarySubset", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/RankBinarySubset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2108, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2731, 81, 54, 1, 70, "ObjectName",
 CellID->29995],
Cell[2788, 84, 810, 24, 70, "Usage",
 CellID->21043]
}, Open  ]],
Cell[CellGroupData[{
Cell[3635, 113, 309, 9, 70, "SeeAlsoSection",
 CellID->373],
Cell[3947, 124, 489, 17, 70, "SeeAlso",
 CellID->118]
}, Open  ]],
Cell[CellGroupData[{
Cell[4473, 146, 317, 9, 70, "TutorialsSection",
 CellID->24121758],
Cell[4793, 157, 186, 4, 70, "Tutorials",
 CellID->15462036]
}, Open  ]],
Cell[CellGroupData[{
Cell[5016, 166, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5338, 177, 160, 3, 70, "MoreAbout",
 CellID->575880918],
Cell[5501, 182, 174, 4, 70, "MoreAbout",
 CellID->41784928]
}, Open  ]],
Cell[5690, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

