(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7216,        241]
NotebookOptionsPosition[      5503,        187]
NotebookOutlinePosition[      6590,        217]
CellTagsIndexPosition[      6547,        214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UnrankGrayCodeSubset" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/UnrankGrayCodeSubset"], "UnrankKSubset" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/UnrankKSubset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"UnrankGrayCodeSubset\"\>", 
       2->"\<\"UnrankKSubset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsets and Cycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndCycles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Subsets and Cycles\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RankKSubset", "ObjectName",
 CellID->8059],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RankKSubset", "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the rank of ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-subset ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " of set ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " in the lexicographic ordering of the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-subsets of ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1962]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17667],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnrankGrayCodeSubset",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/UnrankGrayCodeSubset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnrankKSubset",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/UnrankKSubset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27927]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->605034881],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->565348874]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "MoreAbout",
 CellID->117892490]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RankKSubset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 51.2476114}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RankKSubset[s, l] gives the rank of k-subset s of set l in the \
lexicographic ordering of the k-subsets of l.", "synonyms" -> {}, "title" -> 
    "RankKSubset", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/RankKSubset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1960, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2583, 78, 48, 1, 70, "ObjectName",
 CellID->8059],
Cell[2634, 81, 899, 29, 70, "Usage",
 CellID->1962]
}, Open  ]],
Cell[CellGroupData[{
Cell[3570, 115, 311, 9, 70, "SeeAlsoSection",
 CellID->17667],
Cell[3884, 126, 513, 17, 70, "SeeAlso",
 CellID->27927]
}, Open  ]],
Cell[CellGroupData[{
Cell[4434, 148, 318, 9, 70, "TutorialsSection",
 CellID->605034881],
Cell[4755, 159, 187, 4, 70, "Tutorials",
 CellID->565348874]
}, Open  ]],
Cell[CellGroupData[{
Cell[4979, 168, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5301, 179, 160, 3, 70, "MoreAbout",
 CellID->117892490]
}, Open  ]],
Cell[5476, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

