(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9410,        294]
NotebookOptionsPosition[      7124,        233]
NotebookOutlinePosition[      8785,        270]
CellTagsIndexPosition[      8742,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RankGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RankGraph"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"RankGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RankedEmbedding", "ObjectName",
 CellID->12812],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RankedEmbedding", "[", 
       StyleBox["l", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes a set partition ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " of vertices ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " and returns an embedding of the vertices in the plane such that the \
vertices in each block occur on a vertical line with block ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     " vertices on the leftmost line, block ",
     Cell[BoxData[
      FormBox["2", TraditionalForm]], "InlineMath"],
     " vertices in the next line, and so on. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RankedEmbedding", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes a graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and a set partition ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " of the vertices of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and returns the graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with vertices embedded according to ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"RankedEmbedding", "["}], 
       StyleBox["l", "TI"], "]"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RankedEmbedding", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes a graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and a set ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " of vertices of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and returns a ranked embedding of ",
     Cell[BoxData[
      FormBox[
       StyleBox["g", "TI"], TraditionalForm]], "InlineFormula"],
     " in which vertices in ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " are in block ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     ", vertices at distance ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     " from any vertex in block ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     " are in block ",
     Cell[BoxData[
      FormBox["2", TraditionalForm]], "InlineMath"],
     ", and so on."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->13005]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26996],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["RankGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/RankGraph"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1387]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->350028557],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->267205318]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->2797360]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RankedEmbedding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 50.5600938}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RankedEmbedding[l] takes a set partition l of vertices {1, 2, ..., n} \
and returns an embedding of the vertices in the plane such that the vertices \
in each block occur on a vertical line with block 1 vertices on the leftmost \
line, block 2 vertices in the next line, and so on. RankedEmbedding[g, l] \
takes a graph g and a set partition l of the vertices of g and returns the \
graph g with vertices embedded according to RankedEmbedding[ l]. \
RankedEmbedding[g, s] takes a graph g and a set s of vertices of g and \
returns a ranked embedding of g in which vertices in s are in block 1, \
vertices at distance 1 from any vertex in block 1 are in block 2, and so on.",
     "synonyms" -> {}, "title" -> "RankedEmbedding", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/RankedEmbedding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1776, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2399, 75, 53, 1, 70, "ObjectName",
 CellID->12812],
Cell[2455, 78, 3004, 89, 70, "Usage",
 CellID->13005]
}, Open  ]],
Cell[CellGroupData[{
Cell[5496, 172, 311, 9, 70, "SeeAlsoSection",
 CellID->26996],
Cell[5810, 183, 211, 6, 70, "SeeAlso",
 CellID->1387]
}, Open  ]],
Cell[CellGroupData[{
Cell[6058, 194, 318, 9, 70, "TutorialsSection",
 CellID->350028557],
Cell[6379, 205, 187, 4, 70, "Tutorials",
 CellID->267205318]
}, Open  ]],
Cell[CellGroupData[{
Cell[6603, 214, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6925, 225, 157, 3, 70, "MoreAbout",
 CellID->2797360]
}, Open  ]],
Cell[7097, 231, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

