(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8154,        282]
NotebookOptionsPosition[      6237,        220]
NotebookOutlinePosition[      7279,        249]
CellTagsIndexPosition[      7236,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphOptions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphOptions"], 
          "SetGraphOptions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SetGraphOptions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphOptions\"\>", 
       2->"\<\"SetGraphOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetEdgeLabels", "ObjectName",
 CellID->12890],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetEdgeLabels", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns the labels in ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " to edges of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["l", TraditionalForm]], "InlineMath"],
 " is shorter than the number of edges in ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ", then labels get assigned cyclically. "
}], "Notes",
 CellID->29852],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["l", TraditionalForm]], "InlineMath"],
 " is longer than the number of edges in ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ", then the extra labels are ignored."
}], "Notes",
 CellID->951126589]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5186],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetGraphOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SetGraphOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28530]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->255448362],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->282200896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->456669699]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetEdgeLabels - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 15.0450956}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "SetEdgeLabels[g, l] assigns the labels in l to edges of g. ", 
    "synonyms" -> {}, "title" -> "SetEdgeLabels", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/SetEdgeLabels"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1939, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2562, 78, 51, 1, 70, "ObjectName",
 CellID->12890],
Cell[2616, 81, 611, 20, 70, "Usage",
 CellID->31958]
}, Open  ]],
Cell[CellGroupData[{
Cell[3264, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3742, 123, 268, 9, 70, "Notes",
 CellID->29852],
Cell[4013, 134, 268, 9, 70, "Notes",
 CellID->951126589]
}, Closed]],
Cell[CellGroupData[{
Cell[4318, 148, 310, 9, 70, "SeeAlsoSection",
 CellID->5186],
Cell[4631, 159, 501, 17, 70, "SeeAlso",
 CellID->28530]
}, Open  ]],
Cell[CellGroupData[{
Cell[5169, 181, 318, 9, 70, "TutorialsSection",
 CellID->255448362],
Cell[5490, 192, 187, 4, 70, "Tutorials",
 CellID->282200896]
}, Open  ]],
Cell[CellGroupData[{
Cell[5714, 201, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6036, 212, 159, 3, 70, "MoreAbout",
 CellID->456669699]
}, Open  ]],
Cell[6210, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

