(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12279,        401]
NotebookOptionsPosition[      9839,        332]
NotebookOutlinePosition[     11407,        368]
CellTagsIndexPosition[     11364,        365]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphOptions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/GraphOptions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetGraphOptions", "ObjectName",
 CellID->20529],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetGraphOptions", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with the options ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"],
     " set. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetGraphOptions", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TI"], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["opts", "TI"]]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["opts", "TI"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the graph with the options ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["opts", "TI"]]], "InlineFormula"],
     " set for vertices ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["v", "1"], ",", 
        SubscriptBox["v", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     " and the options ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["opts", "TI"]]], "InlineFormula"],
     " set for the graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetGraphOptions", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TI"], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["opts", "TI"]]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["opts", "TI"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]with edges ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["e", "1"], ",", 
        SubscriptBox["e", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     ", works similarly. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetGraphOptions", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["elements", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["opts", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["elements", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["opts", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          RowBox[{
           StyleBox["\[Ellipsis]", "TR"], 
           RowBox[{"}", ","}], 
           StyleBox["opts", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with the options ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["opts", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " set for the elements in the sequence ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elements", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", the options ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["opts", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " set for the elements in the sequence ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elements", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", and so on. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->4578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Here, elements can be a sequence of edges or a sequence of vertices. A tag \
that takes on values ",
 Cell[BoxData["One"], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " can also be passed in as an argument before any options. "
}], "Notes",
 CellID->6],

Cell[TextData[{
 "The default value of the tag is ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " and it is useful if the graph has multiple edges. It informs the function \
about whether all edges that connect a pair of vertices are to be affected or \
only one edge is affected."
}], "Notes",
 CellID->561025105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6193],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["GraphOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/GraphOptions"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->23654]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10733495],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->372661091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->171700245]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetGraphOptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 15.4201052}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "SetGraphOptions[g, opts] returns g with the options opts set. \
SetGraphOptions[g, {v_1, v_2, ..., v_opts}, g_opts] returns the graph with \
the options v_opts set for vertices v_1, v_2, ... and the options g_opts set \
for the graph g. SetGraphOptions[g, {e_1, e_2, ..., e_opts}, g_opts] with \
edges e_1, e_2, ..., works similarly. SetGraphOptions[g, {{elements_1, \
opts_1}, {elements_2, opts_2}, ... }, opts] returns g with the options opts_1 \
set for the elements in the sequence elements_1, the options opts_2 set for \
the elements in the sequence elements_2, and so on. ", "synonyms" -> {}, 
    "title" -> "SetGraphOptions", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/SetGraphOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1788, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2411, 75, 53, 1, 70, "ObjectName",
 CellID->20529],
Cell[2467, 78, 4438, 143, 70, "Usage",
 CellID->4578]
}, Open  ]],
Cell[CellGroupData[{
Cell[6942, 226, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7420, 243, 363, 11, 70, "Notes",
 CellID->6],
Cell[7786, 256, 381, 10, 70, "Notes",
 CellID->561025105]
}, Closed]],
Cell[CellGroupData[{
Cell[8204, 271, 310, 9, 70, "SeeAlsoSection",
 CellID->6193],
Cell[8517, 282, 218, 6, 70, "SeeAlso",
 CellID->23654]
}, Open  ]],
Cell[CellGroupData[{
Cell[8772, 293, 317, 9, 70, "TutorialsSection",
 CellID->10733495],
Cell[9092, 304, 187, 4, 70, "Tutorials",
 CellID->372661091]
}, Open  ]],
Cell[CellGroupData[{
Cell[9316, 313, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[9638, 324, 159, 3, 70, "MoreAbout",
 CellID->171700245]
}, Open  ]],
Cell[9812, 330, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

