(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7919,        251]
NotebookOptionsPosition[      5863,        193]
NotebookOutlinePosition[      7294,        227]
CellTagsIndexPosition[      7251,        224]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RGFs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RGFs"], 
          "SetPartitions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SetPartitions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RGFs\"\>", 
       2->"\<\"SetPartitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetPartitionListViaRGF", "ObjectName",
 CellID->7801],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetPartitionListViaRGF", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists all set partitions of the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " natural numbers, by first listing all restricted growth functions \
(RGFs) on these and then mapping the RGFs to corresponding set partitions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetPartitionListViaRGF", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists all RGFs on the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " natural numbers whose maximum element is ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " and then maps these RGFs into the corresponding set partitions, all of \
which contain exactly ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " blocks."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19225],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGFs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RGFs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SetPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->189217656],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->11710574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->239263488]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetPartitionListViaRGF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 15.6076100}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "SetPartitionListViaRGF[n] lists all set partitions of the first n \
natural numbers, by first listing all restricted growth functions (RGFs) on \
these and then mapping the RGFs to corresponding set partitions. \
SetPartitionListViaRGF[n, k] lists all RGFs on the first n natural numbers \
whose maximum element is k and then maps these RGFs into the corresponding \
set partitions, all of which contain exactly k blocks.", "synonyms" -> {}, 
    "title" -> "SetPartitionListViaRGF", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/SetPartitionListViaRGF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1938, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2561, 78, 59, 1, 70, "ObjectName",
 CellID->7801],
Cell[2623, 81, 1284, 34, 70, "Usage",
 CellID->17740]
}, Open  ]],
Cell[CellGroupData[{
Cell[3944, 120, 311, 9, 70, "SeeAlsoSection",
 CellID->19225],
Cell[4258, 131, 479, 17, 70, "SeeAlso",
 CellID->855]
}, Open  ]],
Cell[CellGroupData[{
Cell[4774, 153, 318, 9, 70, "TutorialsSection",
 CellID->189217656],
Cell[5095, 164, 186, 4, 70, "Tutorials",
 CellID->11710574]
}, Open  ]],
Cell[CellGroupData[{
Cell[5318, 173, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5640, 184, 181, 4, 70, "MoreAbout",
 CellID->239263488]
}, Open  ]],
Cell[5836, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

