(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9924,        328]
NotebookOptionsPosition[      7860,        264]
NotebookOutlinePosition[      9050,        295]
CellTagsIndexPosition[      9007,        292]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AllPairsShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/AllPairsShortestPath"], 
          "MinimumSpanningTree" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/MinimumSpanningTree"], "ShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShortestPath"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AllPairsShortestPath\"\>", 
       2->"\<\"MinimumSpanningTree\"\>", 
       3->"\<\"ShortestPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShortestPathSpanningTree", "ObjectName",
 CellID->8698],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShortestPathSpanningTree", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a shortest-path spanning tree rooted at ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     ", so that a shortest path in graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " from ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " to any other vertex is a path in the tree. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20192]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option ",
 Cell[BoxData[
  ButtonBox["Algorithm",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Algorithm"]], "InlineFormula"],
 " that takes on the values ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dijkstra",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Dijkstra"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["BellmanFord",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/BellmanFord"]], "InlineFormula"],
 " is provided. This allows a choice between Dijkstra's algorithm and the \
Bellman\[Dash]Ford algorithm. "
}], "Notes",
 CellID->32076],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Algorithm",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Algorithm"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". In this case, depending on whether edges have negative weights and \
depending on the density of the graph, the algorithm chooses between ",
 Cell[BoxData[
  ButtonBox["BellmanFord",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/BellmanFord"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dijkstra",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Dijkstra"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->492819567]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7985],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AllPairsShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AllPairsShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimumSpanningTree",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MinimumSpanningTree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->482778542],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->15601461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->677827554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShortestPathSpanningTree - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 23.3890592}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ShortestPathSpanningTree[g, v] constructs a shortest-path spanning tree \
rooted at v, so that a shortest path in graph g from v to any other vertex is \
a path in the tree. ", "synonyms" -> {}, "title" -> 
    "ShortestPathSpanningTree", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ShortestPathSpanningTree"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2119, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2742, 81, 61, 1, 70, "ObjectName",
 CellID->8698],
Cell[2806, 84, 802, 23, 70, "Usage",
 CellID->20192]
}, Open  ]],
Cell[CellGroupData[{
Cell[3645, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4123, 129, 743, 24, 70, "Notes",
 CellID->32076],
Cell[4869, 155, 748, 23, 70, "Notes",
 CellID->492819567]
}, Closed]],
Cell[CellGroupData[{
Cell[5654, 183, 310, 9, 70, "SeeAlsoSection",
 CellID->7985],
Cell[5967, 194, 791, 26, 70, "SeeAlso",
 CellID->6985]
}, Open  ]],
Cell[CellGroupData[{
Cell[6795, 225, 318, 9, 70, "TutorialsSection",
 CellID->482778542],
Cell[7116, 236, 186, 4, 70, "Tutorials",
 CellID->15601461]
}, Open  ]],
Cell[CellGroupData[{
Cell[7339, 245, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7661, 256, 157, 3, 70, "MoreAbout",
 CellID->677827554]
}, Open  ]],
Cell[7833, 262, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

