(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12176,        423]
NotebookOptionsPosition[     10033,        354]
NotebookOutlinePosition[     11123,        384]
CellTagsIndexPosition[     11080,        381]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AnimateGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AnimateGraph"], 
          "ShowGraphArray" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShowGraphArray"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AnimateGraph\"\>", 
       2->"\<\"ShowGraphArray\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Displaying Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowGraph", "ObjectName",
 CellID->18970],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowGraph", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays the graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowGraph", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        ButtonBox["Directed",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Directed"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]is obsolete and it is currently identical to ",
     Cell[BoxData[
      RowBox[{"ShowGraph", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15626]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "All options that affect the look of a graph can be specified as ",
 Cell[BoxData[
  StyleBox["options", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData["ShowGraph"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2673],

Cell[TextData[{
 "The list of ",
 Cell[BoxData[
  StyleBox["options", "TI"]], "InlineFormula"],
 " are: ",
 Cell[BoxData[
  ButtonBox["VertexColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexNumber"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexNumberColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexNumberColor"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexNumberPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexNumberPosition"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexLabelColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabelColor"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexLabelPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabelPosition"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeLabel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeLabelColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeLabelColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeLabelPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeLabelPosition"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LoopPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/LoopPosition"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["EdgeDirection",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeDirection"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->99217132],

Cell[TextData[{
 "In addition, ",
 Cell[BoxData[
  StyleBox["options", "TI"]], "InlineFormula"],
 " of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["options", "TI"]], "InlineFormula"],
 " of the graphics primitive ",
 Cell[BoxData[
  ButtonBox["Arrow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arrow"]], "InlineFormula"],
 " can also be specified here. "
}], "Notes",
 CellID->432223562],

Cell[TextData[{
 "If an option specified in ",
 Cell[BoxData["ShowGraph"], "InlineFormula"],
 " differs from ",
 Cell[BoxData[
  StyleBox["options", "TI"]], "InlineFormula"],
 " explicitly set within a graph object, then ",
 Cell[BoxData[
  StyleBox["options", "TI"]], "InlineFormula"],
 " specified inside the graph object are used."
}], "Notes",
 CellID->777617193]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2669],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AnimateGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AnimateGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowGraphArray",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShowGraphArray"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7937]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->348940352],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->83115402]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->35516114],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->792491223]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 23.7484434}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ShowGraph[g] displays the graph g. ShowGraph[g, Directed] is obsolete \
and it is currently identical to ShowGraph[g]. ", "synonyms" -> {}, "title" -> 
    "ShowGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ShowGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2154, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2777, 82, 47, 1, 70, "ObjectName",
 CellID->18970],
Cell[2827, 85, 937, 30, 70, "Usage",
 CellID->15626]
}, Open  ]],
Cell[CellGroupData[{
Cell[3801, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4279, 137, 236, 8, 70, "Notes",
 CellID->2673],
Cell[4518, 147, 2416, 86, 70, "Notes",
 CellID->99217132],
Cell[6937, 235, 568, 22, 70, "Notes",
 CellID->432223562],
Cell[7508, 259, 367, 11, 70, "Notes",
 CellID->777617193]
}, Closed]],
Cell[CellGroupData[{
Cell[7912, 275, 310, 9, 70, "SeeAlsoSection",
 CellID->2669],
Cell[8225, 286, 498, 17, 70, "SeeAlso",
 CellID->7937]
}, Open  ]],
Cell[CellGroupData[{
Cell[8760, 308, 318, 9, 70, "TutorialsSection",
 CellID->348940352],
Cell[9081, 319, 186, 4, 70, "Tutorials",
 CellID->83115402]
}, Open  ]],
Cell[CellGroupData[{
Cell[9304, 328, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[9626, 339, 158, 3, 70, "MoreAbout",
 CellID->35516114],
Cell[9787, 344, 204, 5, 70, "MoreAbout",
 CellID->792491223]
}, Open  ]],
Cell[10006, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

